/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jdesktop.application.utils.PlatformType;

public final class AppHelper {
    private static PlatformType activePlatformType = null;

    private AppHelper() {
    }

    public static PlatformType getPlatform() {
        if (activePlatformType != null) {
            return activePlatformType;
        }
        activePlatformType = PlatformType.DEFAULT;
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        String string = AccessController.doPrivileged(privilegedAction);
        if (string != null) {
            string = string.toLowerCase();
            for (PlatformType platformType : PlatformType.values()) {
                for (String string2 : platformType.getPatterns()) {
                    if (!string.startsWith(string2)) continue;
                    activePlatformType = platformType;
                    return activePlatformType;
                }
            }
        }
        activePlatformType = PlatformType.DEFAULT;
        return activePlatformType;
    }
}

