/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;

public final class SwingHelper {
    private SwingHelper() {
    }

    public static Rectangle computeVirtualGraphicsBounds() {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(graphicsConfiguration.getBounds());
        }
        return rectangle;
    }

    public static boolean isResizable(Window window) {
        boolean bl = true;
        if (window instanceof Frame) {
            bl = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            bl = ((Dialog)window).isResizable();
        }
        return bl;
    }

    public static Point defaultLocation(Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = window.getToolkit().getScreenInsets(graphicsConfiguration);
        int n = rectangle.x + insets.left;
        int n2 = rectangle.y + insets.top;
        return new Point(n, n2);
    }

    public static RootPaneContainer findRootPaneContainer(Component component) {
        while (component != null) {
            if (component instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)component);
            }
            if (component instanceof JPopupMenu && component.getParent() == null) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        return null;
    }
}

