/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.AnnotationProcessor;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.annotation.processing.Printer;
import jlibs.core.graph.Filter;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.Visitor;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.sequences.FilteredSequence;
import jlibs.core.graph.sequences.IterableSequence;
import jlibs.core.lang.model.ModelUtil;

@SupportedAnnotationTypes(value={"jlibs.core.graph.Visitor.Implement"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class VisitorAnnotationProcessor
extends AnnotationProcessor {
    private static final String METHOD_NAME = "doVisit";
    private static final String SUFFIX = "Impl";
    public static final String FORMAT = "${package}.${class}Impl";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                LinkedHashMap<TypeMirror, ExecutableElement> classes = new LinkedHashMap<TypeMirror, ExecutableElement>();
                try {
                    TypeElement c = (TypeElement)element;
                    while (c != null && !c.getQualifiedName().contentEquals(Object.class.getName())) {
                        this.process(classes, c);
                        c = ModelUtil.getSuper(c);
                    }
                    c = (TypeElement)element;
                    Printer pw = null;
                    try {
                        pw = Printer.get(c, Visitor.Implement.class, FORMAT);
                        boolean implementing = Environment.get().getTypeUtils().isAssignable(element.asType(), Environment.get().getElementUtils().getTypeElement(Visitor.class.getCanonicalName()).asType());
                        boolean isFinal = c.getModifiers().contains((Object)Modifier.FINAL);
                        if (!isFinal && implementing) {
                            this.generateExtendingClass(classes, pw);
                            continue;
                        }
                        this.generateDelegatingClass(classes, pw);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        if (pw == null) continue;
                        pw.close();
                    }
                }
                catch (AnnotationError error) {
                    error.report();
                }
            }
        }
        return true;
    }

    private boolean accept(ExecutableElement method) {
        return method.getSimpleName().contentEquals(METHOD_NAME) && method.getParameters().size() == 1;
    }

    private void process(Map<TypeMirror, ExecutableElement> classes, TypeElement c) {
        for (ExecutableElement method : ElementFilter.methodsIn(c.getEnclosedElements())) {
            TypeMirror mirror;
            if (!this.accept(method) || classes.containsKey(mirror = method.getParameters().get(0).asType())) continue;
            classes.put(mirror, method);
        }
    }

    private void generateExtendingClass(Map<TypeMirror, ExecutableElement> classes, Printer printer) {
        printer.printPackage();
        printer.printClassDoc();
        printer.printlns("@SuppressWarnings(\"unchecked\")", "public class " + printer.generatedClazz + " extends " + printer.clazz.getSimpleName() + "{", "indent++");
        this.printVisitMethod("", classes, printer);
        printer.printlns("indent--", "}");
    }

    private void generateDelegatingClass(Map<TypeMirror, ExecutableElement> classes, Printer printer) {
        printer.printPackage();
        printer.printClassDoc();
        printer.printlns("public class " + printer.generatedClazz + " implements " + Visitor.class.getCanonicalName() + "{", "indent++", "private final " + printer.clazz.getSimpleName() + " delegate;", "public " + printer.generatedClazz + "(" + printer.clazz.getSimpleName() + " delegate){", "indent++", "this.delegate = delegate;", "indent--", "}");
        printer.emptyLine(true);
        this.printVisitMethod("delegate.", classes, printer);
        printer.printlns("indent--", "}");
    }

    private void printVisitMethod(String prefix, Map<TypeMirror, ExecutableElement> classes, Printer printer) {
        printer.println("@Override");
        printer.println("public Object visit(Object obj){");
        ++printer.indent;
        ArrayList<TypeMirror> list = new ArrayList<TypeMirror>(classes.keySet());
        Collections.reverse(list);
        boolean addElse = false;
        for (TypeMirror mirror : VisitorAnnotationProcessor.sort(list)) {
            String type = ModelUtil.toString(mirror, true);
            if (addElse) {
                printer.print("else ");
            } else {
                addElse = true;
            }
            printer.println("if(obj instanceof " + type + ")");
            ++printer.indent;
            if (classes.get(mirror).getReturnType().getKind() != TypeKind.VOID) {
                printer.print("return ");
            }
            printer.println(prefix + "doVisit((" + type + ")obj);");
            --printer.indent;
        }
        printer.println();
        printer.println("return null;");
        --printer.indent;
        printer.println("}");
    }

    public static List<TypeMirror> sort(final Sequence<TypeMirror> classes) {
        return WalkerUtil.topologicalSort(classes, new Navigator<TypeMirror>(){

            @Override
            public Sequence<TypeMirror> children(final TypeMirror parent) {
                return new FilteredSequence<TypeMirror>(classes.copy(), new Filter<TypeMirror>(){

                    @Override
                    public boolean select(TypeMirror child) {
                        return Environment.get().getTypeUtils().isSubtype(parent, child);
                    }
                });
            }
        });
    }

    public static List<TypeMirror> sort(Collection<TypeMirror> classes) {
        return VisitorAnnotationProcessor.sort(new IterableSequence<TypeMirror>(classes));
    }
}

