/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.NotationDeclaration;
import jlibs.xml.sax.AbstractXMLReader;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.stream.STAXAttributes;
import jlibs.xml.stream.STAXLocator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class STAXXMLReader
extends AbstractXMLReader {
    private XMLInputFactory factory;

    public STAXXMLReader(XMLInputFactory factory) {
        this.factory = factory;
    }

    public STAXXMLReader() {
        this(XMLInputFactory.newInstance());
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        XMLStreamReader reader = null;
        try {
            reader = input.getByteStream() != null ? this.factory.createXMLStreamReader(input.getByteStream(), input.getEncoding()) : (input.getCharacterStream() != null ? this.factory.createXMLStreamReader(input.getCharacterStream()) : this.factory.createXMLStreamReader(input.getSystemId(), (InputStream)null));
            STAXXMLReader.fire(reader, this.handler);
        }
        catch (XMLStreamException ex) {
            throw new SAXException(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (XMLStreamException ex) {
                throw new SAXException(ex);
            }
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public static void fire(XMLStreamReader reader, SAXDelegate handler) throws SAXException {
        STAXAttributes attrs = new STAXAttributes(reader);
        int eventType = reader.getEventType();
        while (true) {
            switch (eventType) {
                case 7: {
                    handler.setDocumentLocator(new STAXLocator(reader));
                    handler.startDocument();
                    break;
                }
                case 1: {
                    String uri;
                    String prefix;
                    int nsCount = reader.getNamespaceCount();
                    for (int i = 0; i < nsCount; ++i) {
                        prefix = reader.getNamespacePrefix(i);
                        uri = reader.getNamespaceURI(i);
                        handler.startPrefixMapping(prefix == null ? "" : prefix, uri == null ? "" : uri);
                    }
                    String localName = reader.getLocalName();
                    prefix = reader.getPrefix();
                    String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
                    String uri2 = reader.getNamespaceURI();
                    handler.startElement(uri2 == null ? "" : uri2, localName, qname, attrs);
                    break;
                }
                case 4: {
                    handler.characters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    break;
                }
                case 12: {
                    handler.startCDATA();
                    handler.characters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    handler.endCDATA();
                    break;
                }
                case 5: {
                    handler.comment(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    break;
                }
                case 3: {
                    handler.processingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 6: {
                    handler.ignorableWhitespace(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    break;
                }
                case 11: {
                    for (NotationDeclaration notation : (List)reader.getProperty("javax.xml.stream.notations")) {
                        handler.notationDecl(notation.getName(), notation.getPublicId(), notation.getSystemId());
                    }
                    for (EntityDeclaration entity : (List)reader.getProperty("javax.xml.stream.entities")) {
                        handler.unparsedEntityDecl(entity.getName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                    }
                    break;
                }
                case 2: {
                    String localName = reader.getLocalName();
                    String prefix = reader.getPrefix();
                    String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
                    String uri = reader.getNamespaceURI();
                    handler.endElement(uri == null ? "" : uri, localName, qname);
                    int nsCount = reader.getNamespaceCount();
                    for (int i = 0; i < nsCount; ++i) {
                        prefix = reader.getNamespacePrefix(i);
                        handler.endPrefixMapping(prefix == null ? "" : prefix);
                    }
                    break;
                }
                case 8: {
                    handler.endDocument();
                    return;
                }
            }
            eventType = reader.getEventType();
        }
    }
}

