/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;

class EmailErrorReporter
implements ErrorReporter {
    private static final Logger logger = Logger.getLogger(EmailErrorReporter.class.getName());
    private static final String MAIL_FOR_ERRORS = "info@wordrider.net";

    EmailErrorReporter() {
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        String string = String.format("Basic Error message:%s%nCategory:%sState:%s%nException:%s%n", errorInfo.getBasicErrorMessage(), errorInfo.getCategory(), EmailErrorReporter.mapToString(errorInfo.getState()), errorInfo.getErrorException().toString());
        string = EmailErrorReporter.encode(string);
        String string2 = String.format("mailto:%s?subject=%s&body=%s", MAIL_FOR_ERRORS, EmailErrorReporter.encode("ERModeller Error report"), string);
        try {
            desktop.mail(new URI(string2));
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            LogUtils.processException(logger, uRISyntaxException);
        }
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtils.processException(logger, unsupportedEncodingException);
            return "";
        }
    }

    private static String mapToString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

