/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.search.SearchItem;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;

public class SearchField
extends JTextField
implements FocusListener,
PopupMenuListener {
    private String emptyString;
    private static final int PREFFERED_HEIGHT = 25;
    private JToggleButton btn;
    private SearchItem selectedItem = null;
    private List<SearchItem> searchItemList = Collections.emptyList();

    public SearchField(ApplicationContext applicationContext) {
        this.addFocusListener(this);
        this.emptyString = "";
        this.btn = new JToggleButton("");
        this.btn.setSize(19, 19);
        this.btn.setMinimumSize(this.btn.getSize());
        this.btn.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.btn.setFocusable(false);
        this.add(this.btn);
        this.btn.setCursor(Cursor.getDefaultCursor());
        Border border = this.getBorder();
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 25, 0, 0)));
        this.btn.setLocation(border == null ? 2 : border.getBorderInsets((Component)this).left, this.getInsets().top);
        Dimension dimension = new Dimension(AppPrefs.getProperty("searchFieldWidth", 165), 25);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.addFocusListener(new ComponentFactory.SelectAllOnFocusListener());
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchField.this.doPopmenu();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (SearchField.this.hasFocus() && keyEvent.isAltDown() && keyEvent.getKeyCode() == 40) {
                    SearchField.this.doPopmenu();
                    keyEvent.consume();
                }
            }
        });
        Swinger.initActions(this, applicationContext);
    }

    @Action
    public void manageSearchEngines() {
        Swinger.showInformationDialog(Swinger.getResourceMap().getString("howToManageSearchEngines", new Object[0]));
        Browser.openBrowser("https://addons.mozilla.org/en-US/firefox/search-engines/");
    }

    private void doPopmenu() {
        if (this.searchItemList == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (SearchItem searchItem : this.searchItemList) {
            jPopupMenu.add(new SelectSearchEngineAction(searchItem));
        }
        if (!this.searchItemList.isEmpty()) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(Swinger.getAction("manageSearchEngines"));
        jPopupMenu.show(this.getParent(), this.getLocation().x, this.getLocation().y + this.getHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.hasFocus() && this.getText().isEmpty() && this.emptyString != null && !this.emptyString.isEmpty()) {
            graphics.setColor(Color.GRAY);
            Font font = this.getFont().deriveFont(2);
            graphics.setFont(font);
            Rectangle2D rectangle2D = graphics.getFontMetrics(font).getStringBounds(this.emptyString, graphics);
            graphics.drawString(this.emptyString, this.getInsets().left, this.getHeight() + this.getInsets().top - this.getInsets().bottom - (int)(rectangle2D.getHeight() / 2.0));
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.btn.getModel().setSelected(false);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.focusGained(focusEvent);
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setEmptyString(String string) {
        this.emptyString = string;
        this.repaint();
    }

    public List<SearchItem> getSearchItemList() {
        return this.searchItemList;
    }

    public void setSearchItemList(List<SearchItem> list) {
        if (list == null) {
            throw new IllegalArgumentException("Search list cannot be null");
        }
        String string = AppPrefs.getProperty("searchFieldSearchEngine", "google");
        this.searchItemList = list;
        for (SearchItem searchItem : list) {
            if (!searchItem.getId().equals(string)) continue;
            this.setSelectedItem(searchItem);
            return;
        }
        if (list.isEmpty()) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(list.get(0));
        }
    }

    public SearchItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(SearchItem searchItem) {
        String string;
        this.selectedItem = searchItem;
        if (searchItem == null) {
            this.setEmptyString("");
            this.btn.setIcon(null);
            string = null;
        } else {
            string = searchItem.getId();
            this.btn.setIcon(searchItem.getImage());
            this.setEmptyString(searchItem.getSearchDescription().getShortName());
        }
        AppPrefs.storeProperty("searchFieldSearchEngine", string);
    }

    private class SelectSearchEngineAction
    extends AbstractAction {
        private final SearchItem item;

        private SelectSearchEngineAction(SearchItem searchItem) {
            super(searchItem.getSearchDescription().getShortName(), searchItem.getImage());
            this.putValue("ShortDescription", searchItem.getSearchDescription().getShortName());
            this.putValue("LongDescription", searchItem.getSearchDescription().getDescription());
            this.item = searchItem;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchField.this.setSelectedItem(this.item);
            Swinger.inputFocus(SearchField.this);
        }
    }
}

