/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.dialogs.filechooser.EnhancedFileFilter;
import cz.vity.freerapid.gui.dialogs.filechooser.IFileType;
import cz.vity.freerapid.gui.dialogs.filechooser.JAppFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.SaveFileChooser;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.ApplicationContext;

public class OpenSaveDialogFactory {
    private static OpenSaveDialogFactory instance = null;

    private OpenSaveDialogFactory(ApplicationContext applicationContext) {
    }

    public static synchronized OpenSaveDialogFactory getInstance(ApplicationContext applicationContext) {
        if (instance == null) {
            return new OpenSaveDialogFactory(applicationContext);
        }
        return instance;
    }

    public File getSaveResultsDialog() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(3);
        arrayList.add(new EnhancedFileFilter(new String[]{"txt"}, "filterTxt", new Object[0]));
        arrayList.add(new EnhancedFileFilter(new String[]{"csv"}, "filterCsv", new Object[0]));
        arrayList.add(new EnhancedFileFilter(new String[]{"dxf"}, "filterDxf", new Object[0]));
        String string = AppPrefs.getProperty("lastUsedFolderExport", "export");
        String string2 = AppPrefs.getProperty("lastExportFilename", new File(string).getName());
        File file = this.getSaveFileDialog(arrayList, "lastExportFilter", "lastUsedFolderExport", string2);
        if (file != null) {
            AppPrefs.storeProperty("lastExportFilename", file.getName());
        }
        return file;
    }

    public File[] getChooseImageFileDialog() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(3);
        arrayList.add(new EnhancedFileFilter(new String[]{"tif", "tiff"}, "filterTIF", new Object[0]));
        return this.getOpenFileDialog(arrayList, "lastUsedImportFilter", "importLastUsedFolder", false);
    }

    private File[] getOpenFileDialog(List<EnhancedFileFilter> list, String string, String string2, boolean bl) {
        File[] fileArray;
        OpenFileChooser openFileChooser = new OpenFileChooser(new File(AppPrefs.getProperty(string2, "")));
        openFileChooser.updateFileFilters(list, string);
        openFileChooser.setAcceptAllFileFilterUsed(false);
        openFileChooser.setMultiSelectionEnabled(bl);
        int n = openFileChooser.showOpenDialog(Frame.getFrames()[0]);
        if (n != 0) {
            return new File[0];
        }
        AppPrefs.storeProperty(string, list.indexOf(openFileChooser.getFileFilter()));
        AppPrefs.storeProperty(string2, FRDUtils.getAbsRelPath(openFileChooser.getSelectedFile()).getPath());
        if (bl) {
            fileArray = openFileChooser.getSelectedFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = openFileChooser.getSelectedFile();
        }
        return fileArray;
    }

    private File getSaveFileDialog(List<EnhancedFileFilter> list, String string, String string2, String string3) {
        int n;
        String string4;
        SaveFileChooser saveFileChooser = new SaveFileChooser(new File(AppPrefs.getProperty(string2, "")));
        saveFileChooser.setMultiSelectionEnabled(false);
        saveFileChooser.setAcceptAllFileFilterUsed(false);
        saveFileChooser.setFileName(string3);
        saveFileChooser.updateFileFilters(list, string);
        int n2 = saveFileChooser.showSaveDialog(Frame.getFrames()[0]);
        if (n2 != 0) {
            return null;
        }
        File file = saveFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        FileFilter fileFilter = saveFileChooser.getFileFilter();
        if (fileFilter instanceof IFileType && Utils.getExtension(file) == null) {
            string4 = ((IFileType)((Object)fileFilter)).getExtension();
            file = new File(file.getPath().concat(".").concat(string4));
        }
        if (file.isFile() && file.exists() && (n = Swinger.getChoiceYesNoCancel((string4 = Swinger.getResourceMap(JAppFileChooser.class)).getString("message.confirm.overwrite", new Object[0]))) == 1) {
            return null;
        }
        AppPrefs.storeProperty(string, list.indexOf(fileFilter));
        AppPrefs.storeProperty(string2, file.getPath());
        return file;
    }

    public File[] getChooseProxyList() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(1);
        arrayList.add(new EnhancedFileFilter(new String[]{"txt", "list"}, "filterTxt", new Object[0]));
        return this.getOpenFileDialog(arrayList, "lastUsedImportFilter", "importLastUsedFolder", false);
    }

    public File[] getImportLinks(List<String[]> list) {
        return this.getOpenFileDialog(OpenSaveDialogFactory.getFilters(list, false), "lastUsedImportFilter", "importLastUsedFolder", true);
    }

    public File getExportLinks(List<String[]> list) {
        return this.getSaveFileDialog(OpenSaveDialogFactory.getFilters(list, true), "lastExportFilter", "lastUsedFolderExport", "");
    }

    private static List<EnhancedFileFilter> getFilters(List<String[]> list, boolean bl) {
        String[] stringArray = OpenSaveDialogFactory.getAllSupported(list);
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(stringArray.length + 1);
        if (!bl) {
            arrayList.add(new EnhancedFileFilter(stringArray, "allSupportedFiles", new Object[0]));
        }
        for (String[] stringArray2 : list) {
            if (stringArray2[0].equals("txt")) {
                arrayList.add(new EnhancedFileFilter(stringArray2, "filterTxt", new Object[0]));
                continue;
            }
            if (stringArray2[0].equals("csv")) {
                arrayList.add(new EnhancedFileFilter(stringArray2, "filterCsv", new Object[0]));
                continue;
            }
            arrayList.add(new EnhancedFileFilter(stringArray2, "filterContainer", stringArray2[0].toUpperCase(Locale.ENGLISH)));
        }
        return arrayList;
    }

    private static String[] getAllSupported(List<String[]> list) {
        int n = 0;
        for (String[] object : list) {
            n += object.length;
        }
        String[] stringArray = new String[n];
        n = 0;
        for (String[] stringArray2 : list) {
            System.arraycopy(stringArray2, 0, stringArray, n, stringArray2.length);
            n += stringArray2.length;
        }
        return stringArray;
    }
}

