/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

class DownloadService {
    private Collection<ConnectionSettings> downloading = new Vector<ConnectionSettings>();
    private Collection<DownloadFile> testing = new Vector<DownloadFile>();
    private Collection<ConnectionSettings> problems = new Vector<ConnectionSettings>();
    private String serviceName;
    private int maxDownloads;

    public DownloadService(PluginMetaData pluginMetaData, ShareDownloadService shareDownloadService) {
        this.setPluginMetaData(pluginMetaData);
    }

    public boolean canDownloadWith(ConnectionSettings connectionSettings) {
        if (this.problems.contains(connectionSettings)) {
            return false;
        }
        int n = 0;
        for (ConnectionSettings connectionSettings2 : this.downloading) {
            if (!connectionSettings2.equals(connectionSettings) || ++n < this.maxDownloads) continue;
            return false;
        }
        return true;
    }

    public boolean canDownloadBeforeCheck(DownloadFile downloadFile, List<DownloadFile> list, boolean bl) {
        if (this.testing.isEmpty()) {
            return true;
        }
        int n = list.indexOf(downloadFile);
        for (DownloadFile downloadFile2 : this.testing) {
            int n2 = list.indexOf(downloadFile2);
            if (!(bl ? n2 < n : n2 > n)) continue;
            return false;
        }
        return true;
    }

    public void addTestingFile(DownloadFile downloadFile) {
        this.testing.add(downloadFile);
    }

    public void finishedTestingFile(DownloadFile downloadFile) {
        this.testing.remove(downloadFile);
    }

    public void addDownloadingClient(HttpDownloadClient httpDownloadClient) {
        this.downloading.add(httpDownloadClient.getSettings());
    }

    public void addProblematicConnection(ConnectionSettings connectionSettings) {
        this.problems.add(connectionSettings);
    }

    public void removeProblematicConnection(ConnectionSettings connectionSettings) {
        this.problems.remove(connectionSettings);
    }

    public void finishedDownloading(HttpDownloadClient httpDownloadClient) {
        this.downloading.remove(httpDownloadClient.getSettings());
    }

    public int getProblematicConnectionsCount() {
        return this.problems.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DownloadService downloadService = (DownloadService)object;
        return this.serviceName.equals(downloadService.serviceName);
    }

    public int hashCode() {
        return this.serviceName.hashCode();
    }

    public String toString() {
        return this.serviceName;
    }

    public void setPluginMetaData(PluginMetaData pluginMetaData) {
        this.serviceName = pluginMetaData.getServices();
        this.maxDownloads = pluginMetaData.getMaxAllowedDownloads();
    }
}

