/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers.search;

import cz.vity.freerapid.gui.managers.search.OpenSearchDescription;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.DataURI;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class SearchItem {
    private final String id;
    private OpenSearchDescription searchDescription;
    private ImageIcon image;
    private static final Logger logger = Logger.getLogger(SearchItem.class.getName());

    public SearchItem(String string, OpenSearchDescription openSearchDescription) {
        this.id = string;
        this.searchDescription = openSearchDescription;
    }

    public String getId() {
        return this.id;
    }

    public ImageIcon getImage() {
        if (this.image == null) {
            String string = this.searchDescription.getImage();
            if (string != null) {
                if ((string = string.trim()).toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                    try {
                        URL uRL = new URL(string);
                        this.image = new ImageIcon(Toolkit.getDefaultToolkit().getImage(uRL));
                    }
                    catch (Exception exception) {
                        logger.warning("Invalid URL for search item image: " + string + " " + exception.getMessage());
                    }
                } else {
                    DataURI dataURI = DataURI.parse(string);
                    if (dataURI != null) {
                        this.image = new ImageIcon(dataURI.toImage());
                    }
                }
            }
            if (this.image == null) {
                this.image = this.getDefaultSearchIcon();
                return this.image;
            }
        }
        return this.image;
    }

    private ImageIcon getDefaultSearchIcon() {
        return Swinger.getIconImage("searchDefaultIcon");
    }

    public OpenSearchDescription getSearchDescription() {
        return this.searchDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SearchItem searchItem = (SearchItem)object;
        return !(this.id == null ? searchItem.id != null : !this.id.equals(searchItem.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

