/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.exceptions.BuildMethodException;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;

public final class MethodBuilder {
    private static final Logger logger = Logger.getLogger(MethodBuilder.class.getName());
    private static final Random random = new Random();
    private static final int FORM_MATCHER_TITLE_GROUP = 1;
    private static final int FORM_MATCHER_FORM_CONTENT = 2;
    private final String content;
    private HttpDownloadClient client;
    private Map<String, String> parameters = new LinkedHashMap<String, String>(4);
    private String referer;
    private String action;
    private HttpMethodEnum postMethod = HttpMethodEnum.POST;
    private String baseURL;
    private boolean encodeParameters = false;
    private String encoding = "UTF-8";
    private boolean autoReplaceEntities = true;
    private boolean encodePathAndQuery;
    private boolean addWww = false;
    private static Pattern formPattern;
    private static Pattern parameterInputPattern;
    private static Pattern parameterTypePattern;
    private static Pattern parameterNamePattern;
    private static Pattern parameterValuePattern;
    private static Pattern aHrefPattern;
    private static Pattern imgPattern;
    private static Pattern iframePattern;
    private boolean updateWww = false;

    public HttpMethodEnum getMethodAction() {
        return this.postMethod;
    }

    public MethodBuilder(String string, HttpDownloadClient httpDownloadClient) {
        this.content = string;
        this.client = httpDownloadClient;
    }

    public MethodBuilder(HttpDownloadClient httpDownloadClient) {
        this(httpDownloadClient.getContentAsString(), httpDownloadClient);
    }

    public MethodBuilder setActionFromFormByName(String string, boolean bl) throws BuildMethodException {
        Matcher matcher = this.getFormMatcher();
        int n = 0;
        boolean bl2 = false;
        Pattern pattern = Pattern.compile("(?:name|id)\\s?=\\s?(?:\"|')?" + string + "(?:\"|'|\\s|>|$)", 10);
        while (matcher.find(n)) {
            String string2 = matcher.group(1);
            if (pattern.matcher(string2).find()) {
                this.inputForm(bl, string2, matcher.group(2));
                bl2 = true;
                break;
            }
            n = matcher.end();
        }
        if (!bl2) {
            throw new BuildMethodException("Tag <Form> with a name or ID '" + string + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormWhereActionContains(String string, boolean bl) throws BuildMethodException {
        Matcher matcher = this.getFormMatcher();
        boolean bl2 = false;
        int n = 0;
        String string2 = string.toLowerCase();
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            String string4 = this.extractAction(string3);
            if (string4 != null && string4.toLowerCase().contains(string2)) {
                this.inputForm(bl, string3, matcher.group(2));
                bl2 = true;
                break;
            }
            n = matcher.end();
        }
        if (!bl2) {
            throw new BuildMethodException("<Form> with defined action containing '" + string + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormWhereTagContains(String string, boolean bl) throws BuildMethodException {
        Matcher matcher = this.getFormMatcher();
        boolean bl2 = false;
        int n = 0;
        String string2 = string.toLowerCase();
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            if (string3.toLowerCase().contains(string2) || matcher.group(2).toLowerCase().contains(string2)) {
                this.inputForm(bl, string3, matcher.group(2));
                bl2 = true;
                break;
            }
            n = matcher.end();
        }
        if (!bl2) {
            throw new BuildMethodException("Tag <Form> containing '" + string + "' in the title was not found!");
        }
        return this;
    }

    public MethodBuilder setWww(boolean bl) {
        this.updateWww = true;
        this.addWww = bl;
        return this;
    }

    public MethodBuilder setActionFromTextBetween(String string, String string2) throws BuildMethodException {
        if (string == null) {
            throw new IllegalArgumentException("The text before the searched string cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The text after the searched string cannot be null");
        }
        Matcher matcher = Pattern.compile(Pattern.quote(Utils.rtrim(string)) + "\\s*(.+?)\\s*" + Pattern.quote(Utils.ltrim(string2)), 42).matcher(this.content);
        if (!matcher.find()) {
            throw new BuildMethodException(String.format("The searched text between string '%s' and '%s' was not found.", string, string2));
        }
        this.action = matcher.group(1).trim();
        this.postMethod = HttpMethodEnum.GET;
        this.checkAutoreplaceEntities();
        return this;
    }

    public MethodBuilder setActionFromAHrefWhereATagContains(String string) throws BuildMethodException {
        Matcher matcher = this.getAHrefMatcher();
        boolean bl = false;
        int n = 0;
        String string2 = string.toLowerCase();
        while (matcher.find(n)) {
            String string3 = matcher.group(2);
            if (string3.toLowerCase().contains(string2)) {
                this.action = matcher.group(1);
                this.checkAutoreplaceEntities();
                bl = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            n = matcher.end();
        }
        if (!bl) {
            throw new BuildMethodException("Tag <A> containing '" + string + "' was not found!");
        }
        return this;
    }

    private void checkAutoreplaceEntities() {
        if (this.autoReplaceEntities && this.action != null) {
            this.action = this.action.startsWith("&#104;&#116;&#116;&#112;") ? PlugUtils.unescapeHtml(this.action) : PlugUtils.replaceEntities(this.action);
        }
    }

    public MethodBuilder setActionFromImgSrcWhereTagContains(String string) throws BuildMethodException {
        if (imgPattern == null) {
            imgPattern = Pattern.compile("(<img(?:.*?)src\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>)", 42);
        }
        Matcher matcher = imgPattern.matcher(this.content);
        boolean bl = false;
        int n = 0;
        String string2 = string.toLowerCase();
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            if (string3.toLowerCase().contains(string2)) {
                this.action = matcher.group(2);
                this.checkAutoreplaceEntities();
                bl = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            n = matcher.end();
        }
        if (!bl) {
            throw new BuildMethodException("Tag <img> containing '" + string + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromIFrameSrcWhereTagContains(String string) throws BuildMethodException {
        if (iframePattern == null) {
            iframePattern = Pattern.compile("(<i?frame(?:.*?)src\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>)", 42);
        }
        Matcher matcher = iframePattern.matcher(this.content);
        boolean bl = false;
        int n = 0;
        String string2 = string.toLowerCase();
        while (matcher.find(n)) {
            String string3 = matcher.group(1);
            if (string3.toLowerCase().contains(string2)) {
                this.action = matcher.group(2);
                this.checkAutoreplaceEntities();
                bl = true;
                this.postMethod = HttpMethodEnum.GET;
                break;
            }
            n = matcher.end();
        }
        if (!bl) {
            throw new BuildMethodException("Tag <iframe> containing '" + string + "' was not found!");
        }
        return this;
    }

    public MethodBuilder setActionFromFormByIndex(int n, boolean bl) throws BuildMethodException {
        if (n < 1) {
            throw new IllegalArgumentException("Index must be higher or equal to 1");
        }
        Matcher matcher = this.getFormMatcher();
        int n2 = 0;
        int n3 = 1;
        boolean bl2 = false;
        while (matcher.find(n2)) {
            if (n3++ == n) {
                bl2 = true;
                this.inputForm(bl, matcher.group(1), matcher.group(2));
                break;
            }
            n2 = matcher.end();
        }
        if (!bl2) {
            throw new BuildMethodException("<Form> with index " + n + " from the top was not found");
        }
        return this;
    }

    private HttpMethodEnum extractMethod(String string) {
        Pattern pattern = Pattern.compile("method\\s?=\\s?(?:\"|')?\"(POST|GET)(?:\"|'|\\s*>)", 10);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            if ("POST".equalsIgnoreCase(matcher.group(1))) {
                return HttpMethodEnum.POST;
            }
            return HttpMethodEnum.GET;
        }
        return HttpMethodEnum.POST;
    }

    public MethodBuilder setMethodAction(String string) {
        this.action = string;
        return this;
    }

    public MethodBuilder setBaseURL(String string) throws BuildMethodException {
        if (string == null) {
            this.baseURL = null;
            return this;
        }
        try {
            new java.net.URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BuildMethodException(uRISyntaxException.getMessage());
        }
        this.baseURL = string;
        return this;
    }

    public MethodBuilder addParameters(String ... stringArray) throws BuildMethodException {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("You have to provide some parameter names");
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        hashSet.addAll(Arrays.asList(stringArray));
        this.populateParameters(this.content);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.parameters);
        for (String string : this.parameters.keySet()) {
            if (hashSet.contains(string)) {
                hashSet.remove(string);
                continue;
            }
            linkedHashMap.remove(string);
        }
        if (!hashSet.isEmpty()) {
            throw new BuildMethodException("The parameters " + Arrays.toString(hashSet.toArray()) + " were not found");
        }
        this.parameters = linkedHashMap;
        return this;
    }

    public MethodBuilder removeParameter(String string) {
        this.parameters.remove(string);
        return this;
    }

    public MethodBuilder replaceEntitiesInAction() {
        this.action = PlugUtils.replaceEntities(this.action);
        return this;
    }

    public MethodBuilder unescapeHtml() {
        this.action = PlugUtils.unescapeHtml(this.action);
        return this;
    }

    public MethodBuilder clearParameters() {
        this.parameters.clear();
        return this;
    }

    public MethodBuilder setParameter(String string, String string2) {
        if (string2 == null) {
            return this.removeParameter(string);
        }
        this.parameters.put(string, string2);
        return this;
    }

    public MethodBuilder setAndEncodeParameter(String string, String string2) throws BuildMethodException {
        return this.setParameter(string, this.encode(string2));
    }

    private String encode(String string) throws BuildMethodException {
        String string2;
        try {
            string2 = URLEncoder.encode(string, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuildMethodException(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public MethodBuilder encodeLastPartOfAction() throws BuildMethodException {
        this.setEncodePathAndQuery(true);
        return this;
    }

    public MethodBuilder setEncodePathAndQuery(boolean bl) throws BuildMethodException {
        this.encodePathAndQuery = bl;
        return this;
    }

    public MethodBuilder setReferer(String string) {
        this.referer = string;
        return this;
    }

    public String getReferer() {
        return this.referer;
    }

    public HttpMethod toGetMethod() throws BuildMethodException {
        CharSequence charSequence;
        if (this.referer != null) {
            this.client.setReferer(this.referer);
        }
        String string = this.generateURL();
        if (!this.parameters.isEmpty()) {
            charSequence = new StringBuilder(string);
            if (!string.contains("?")) {
                ((StringBuilder)charSequence).append('?');
            }
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                char c = ((StringBuilder)charSequence).charAt(((StringBuilder)charSequence).length() - 1);
                if (c != '&' && c != '?' && c != '/') {
                    ((StringBuilder)charSequence).append('&');
                }
                ((StringBuilder)charSequence).append(entry.getKey()).append('=');
                if (!this.encodeParameters) {
                    ((StringBuilder)charSequence).append(entry.getValue());
                    continue;
                }
                ((StringBuilder)charSequence).append(this.encode(entry.getValue()));
            }
            string = ((StringBuilder)charSequence).toString();
        }
        try {
            charSequence = this.encodePathAndQuery ? URIUtil.encodePathQuery((String)string, (String)this.encoding) : string;
        }
        catch (URIException uRIException) {
            throw new BuildMethodException("Cannot create URI");
        }
        string = this.checkURI((String)charSequence);
        return this.client.getGetMethod(string);
    }

    private void inputForm(boolean bl, String string, String string2) {
        this.action = this.extractAction(string);
        if (this.action != null) {
            this.checkAutoreplaceEntities();
        } else {
            logger.info("Form has no defined action attribute");
        }
        this.postMethod = this.extractMethod(string);
        if (bl) {
            this.populateParameters(string2);
        }
    }

    private static String getCorrectGroup(Matcher matcher) {
        for (int i = matcher.groupCount(); i > 0; --i) {
            String string = matcher.group(i);
            if (string == null) continue;
            return string;
        }
        throw new IllegalStateException("Group cannot be empty");
    }

    private void populateParameters(String string) {
        if (parameterInputPattern == null) {
            parameterInputPattern = Pattern.compile("<input (.+?>)", 42);
        }
        if (parameterTypePattern == null) {
            parameterTypePattern = Pattern.compile("type\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s|>)", 10);
        }
        if (parameterNamePattern == null) {
            parameterNamePattern = Pattern.compile("(?:name\\s?=\\s?)(?:([\"]([^\"]+)[\">])|([']([^']+)['>])|(([^'\">\\s]+)[/\\s>]))", 10);
        }
        if (parameterValuePattern == null) {
            parameterValuePattern = Pattern.compile("(?:value\\s?=\\s?)(?:([\"]([^\"]+)[\">])|([']([^']+)['>])|(([^'\">\\s]+)[/\\s>]))", 10);
        }
        Matcher matcher = parameterInputPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            Matcher matcher2 = parameterNamePattern.matcher(string2);
            if (!matcher2.find()) continue;
            String string3 = MethodBuilder.getCorrectGroup(matcher2);
            String string4 = null;
            Matcher matcher3 = parameterTypePattern.matcher(string2);
            if (matcher3.find()) {
                string4 = matcher3.group(1);
            }
            if ("image".equals(string4)) {
                this.parameters.put(string3 + ".x", String.valueOf(random.nextInt(100)));
                this.parameters.put(string3 + ".y", String.valueOf(random.nextInt(100)));
                continue;
            }
            Matcher matcher4 = parameterValuePattern.matcher(string2);
            if (matcher4.find()) {
                this.parameters.put(string3, MethodBuilder.getCorrectGroup(matcher4));
                continue;
            }
            this.parameters.put(string3, "");
        }
    }

    private String extractAction(String string) {
        Pattern pattern = Pattern.compile("action\\s?=\\s?(?:\"|')?(.*?)(?:\"|'|\\s*>)", 10);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            if (string2.isEmpty()) {
                return null;
            }
            return string2;
        }
        return null;
    }

    private String generateURL() throws BuildMethodException {
        String string;
        String string2 = this.buildUrl();
        if (this.updateWww && (string = string2.toLowerCase(Locale.ENGLISH)).startsWith("http://")) {
            if (string.startsWith("http://www.")) {
                if (!this.addWww) {
                    string2 = "http://" + string2.substring(11);
                    logger.info("Removing WWW " + string2);
                }
            } else if (this.addWww) {
                string2 = "http://www." + string2.substring(7);
                logger.info("Adding WWW " + string2);
            }
        }
        return string2;
    }

    private String buildUrl() throws BuildMethodException {
        if (this.baseURL == null && this.action == null) {
            throw new BuildMethodException("Both action and base url has to be not null");
        }
        if (this.action != null) {
            if (this.action.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                return this.action;
            }
            if (this.baseURL != null && this.baseURL.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                if (this.action != null) {
                    String string = this.action;
                    if (this.action.startsWith("/")) {
                        string = this.action.substring(1);
                    } else if (this.action.startsWith("./")) {
                        string = this.action.substring(2);
                    }
                    if (!this.baseURL.endsWith("/")) {
                        return this.baseURL + "/" + string;
                    }
                    return this.baseURL + string;
                }
            } else {
                throw new BuildMethodException("Cannot build method. No base URL defined - no action (baseURL or action) starts with 'http'");
            }
        }
        return this.baseURL;
    }

    private String checkURI(String string) throws BuildMethodException {
        String string2 = this.client.getHTTPClient().getParams().getUriCharset();
        logger.info("Converting " + string + " with  URI charset " + string2);
        try {
            return new URI(string, true, string2).toString();
        }
        catch (URIException uRIException) {
            logger.warning(String.format("Invalid URL - '%s' does not match URI specification with URI charset %s", string, string2));
            try {
                return new URI(URIUtil.encodePathQuery((String)string, (String)this.encoding), true, string2).toString();
            }
            catch (URIException uRIException2) {
                throw new BuildMethodException("Invalid URL - does not match URI specification: " + string);
            }
        }
    }

    private Matcher getFormMatcher() {
        if (formPattern == null) {
            formPattern = Pattern.compile("<form(.*?)>(.*?)</form", 42);
        }
        return formPattern.matcher(this.content);
    }

    private Matcher getAHrefMatcher() {
        if (aHrefPattern == null) {
            aHrefPattern = Pattern.compile("<a(?:.*?)href\\s?=\\s?(?:\"|')(.+?)(?:\"|')(?:.*?)>(.*?)</a>", 42);
        }
        return aHrefPattern.matcher(this.content);
    }

    public HttpMethod toPostMethod() throws BuildMethodException {
        if (this.referer != null) {
            this.client.setReferer(this.referer);
        }
        String string = this.generateURL();
        if (this.encodePathAndQuery) {
            try {
                string = URIUtil.encodePathQuery((String)string, (String)this.encoding);
            }
            catch (URIException uRIException) {
                throw new BuildMethodException("Cannot create URI");
            }
        }
        string = this.checkURI(string);
        PostMethod postMethod = this.client.getPostMethod(string);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            postMethod.addParameter(entry.getKey(), this.encodeParameters ? this.encode(entry.getValue()) : entry.getValue());
        }
        return postMethod;
    }

    public HttpMethod toHttpMethod() throws BuildMethodException {
        if (this.postMethod == HttpMethodEnum.POST) {
            return this.toPostMethod();
        }
        return this.toGetMethod();
    }

    public String getAction() {
        return this.action;
    }

    public MethodBuilder setAction(String string) {
        this.action = string;
        if (string.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            this.postMethod = HttpMethodEnum.GET;
        }
        if (this.isAutoReplaceEntitiesEnabled()) {
            this.replaceEntitiesInAction();
        }
        return this;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public HttpDownloadClient getClient() {
        return this.client;
    }

    public void setClient(HttpDownloadClient httpDownloadClient) {
        this.client = httpDownloadClient;
    }

    public boolean isEncodeParameters() {
        return this.encodeParameters;
    }

    public MethodBuilder setEncodeParameters(boolean bl) {
        this.encodeParameters = bl;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public MethodBuilder setEncoding(String string) {
        this.encoding = string;
        return this;
    }

    public boolean isAutoReplaceEntitiesEnabled() {
        return this.autoReplaceEntities;
    }

    public MethodBuilder setAutoReplaceEntities(boolean bl) {
        this.autoReplaceEntities = bl;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getEscapedURI() throws BuildMethodException {
        try {
            return this.toHttpMethod().getURI().getEscapedURI();
        }
        catch (URIException uRIException) {
            throw new BuildMethodException("Cannot build URI from action");
        }
    }

    public static enum HttpMethodEnum {
        POST,
        GET;

    }
}

