/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.crypto;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

final class CipherSpiWrapper {
    private static final Method engineSetMode;
    private static final Method engineSetPadding;
    private static final Method engineGetBlockSize;
    private static final Method engineGetOutputSize;
    private static final Method engineGetIV;
    private static final Method engineGetParameters;
    private static final Method engineInit1;
    private static final Method engineInit2;
    private static final Method engineInit3;
    private static final Method engineUpdate1;
    private static final Method engineUpdate2;
    private static final Method engineUpdate3;
    private static final Method engineDoFinal1;
    private static final Method engineDoFinal2;
    private static final Method engineDoFinal3;
    private static final Method engineWrap;
    private static final Method engineUnwrap;
    private static final Method engineGetKeySize;
    private final CipherSpi wrapped;

    public static CipherSpiWrapper wrap(CipherSpi cipherSpi) {
        return new CipherSpiWrapper(cipherSpi);
    }

    private CipherSpiWrapper(CipherSpi cipherSpi) {
        if (cipherSpi == null) {
            throw new NullPointerException();
        }
        this.wrapped = cipherSpi;
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        try {
            engineSetMode.invoke((Object)this.wrapped, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        try {
            engineSetPadding.invoke((Object)this.wrapped, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchPaddingException) {
                throw (NoSuchPaddingException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineGetBlockSize() {
        try {
            return (Integer)engineGetBlockSize.invoke((Object)this.wrapped, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineGetOutputSize(int n) {
        try {
            return (Integer)engineGetOutputSize.invoke((Object)this.wrapped, n);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public byte[] engineGetIV() {
        try {
            return (byte[])engineGetIV.invoke((Object)this.wrapped, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public AlgorithmParameters engineGetParameters() {
        try {
            return (AlgorithmParameters)engineGetParameters.invoke((Object)this.wrapped, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            engineInit1.invoke((Object)this.wrapped, n, key, secureRandom);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            engineInit2.invoke((Object)this.wrapped, n, key, algorithmParameterSpec, secureRandom);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            engineInit3.invoke((Object)this.wrapped, n, key, algorithmParameters, secureRandom);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public byte[] engineUpdate(byte[] byArray, int n, int n2) {
        try {
            return (byte[])engineUpdate1.invoke((Object)this.wrapped, byArray, n, n2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        try {
            return (Integer)engineUpdate2.invoke((Object)this.wrapped, byArray, n, n2, byArray2, n3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ShortBufferException) {
                throw (ShortBufferException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            return (Integer)engineUpdate3.invoke((Object)this.wrapped, byteBuffer, byteBuffer2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ShortBufferException) {
                throw (ShortBufferException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        try {
            return (byte[])engineDoFinal1.invoke((Object)this.wrapped, byArray, n, n2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IllegalBlockSizeException) {
                throw (IllegalBlockSizeException)throwable;
            }
            if (throwable instanceof BadPaddingException) {
                throw (BadPaddingException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            return (Integer)engineDoFinal2.invoke((Object)this.wrapped, byArray, n, n2, byArray2, n3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ShortBufferException) {
                throw (ShortBufferException)throwable;
            }
            if (throwable instanceof IllegalBlockSizeException) {
                throw (IllegalBlockSizeException)throwable;
            }
            if (throwable instanceof BadPaddingException) {
                throw (BadPaddingException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            return (Integer)engineDoFinal3.invoke((Object)this.wrapped, byteBuffer, byteBuffer2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof ShortBufferException) {
                throw (ShortBufferException)throwable;
            }
            if (throwable instanceof IllegalBlockSizeException) {
                throw (IllegalBlockSizeException)throwable;
            }
            if (throwable instanceof BadPaddingException) {
                throw (BadPaddingException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            return (byte[])engineWrap.invoke((Object)this.wrapped, key);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IllegalBlockSizeException) {
                throw (IllegalBlockSizeException)throwable;
            }
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            return (Key)engineUnwrap.invoke((Object)this.wrapped, byArray, string, n);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int engineGetKeySize(Key key) throws InvalidKeyException {
        try {
            return (Integer)engineGetKeySize.invoke((Object)this.wrapped, key);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidKeyException) {
                throw (InvalidKeyException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(invocationTargetException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CipherSpiWrapper) {
            return this.wrapped.equals(((CipherSpiWrapper)object).wrapped);
        }
        return this.wrapped.equals(object);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    static {
        try {
            engineSetMode = CipherSpi.class.getDeclaredMethod("engineSetMode", String.class);
            engineSetMode.setAccessible(true);
            engineSetPadding = CipherSpi.class.getDeclaredMethod("engineSetPadding", String.class);
            engineSetPadding.setAccessible(true);
            engineGetBlockSize = CipherSpi.class.getDeclaredMethod("engineGetBlockSize", new Class[0]);
            engineGetBlockSize.setAccessible(true);
            engineGetOutputSize = CipherSpi.class.getDeclaredMethod("engineGetOutputSize", Integer.TYPE);
            engineGetOutputSize.setAccessible(true);
            engineGetIV = CipherSpi.class.getDeclaredMethod("engineGetIV", new Class[0]);
            engineGetIV.setAccessible(true);
            engineGetParameters = CipherSpi.class.getDeclaredMethod("engineGetParameters", new Class[0]);
            engineGetParameters.setAccessible(true);
            engineInit1 = CipherSpi.class.getDeclaredMethod("engineInit", Integer.TYPE, Key.class, SecureRandom.class);
            engineInit1.setAccessible(true);
            engineInit2 = CipherSpi.class.getDeclaredMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameterSpec.class, SecureRandom.class);
            engineInit2.setAccessible(true);
            engineInit3 = CipherSpi.class.getDeclaredMethod("engineInit", Integer.TYPE, Key.class, AlgorithmParameters.class, SecureRandom.class);
            engineInit3.setAccessible(true);
            engineUpdate1 = CipherSpi.class.getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE);
            engineUpdate1.setAccessible(true);
            engineUpdate2 = CipherSpi.class.getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
            engineUpdate2.setAccessible(true);
            engineUpdate3 = CipherSpi.class.getDeclaredMethod("engineUpdate", ByteBuffer.class, ByteBuffer.class);
            engineUpdate3.setAccessible(true);
            engineDoFinal1 = CipherSpi.class.getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE);
            engineDoFinal1.setAccessible(true);
            engineDoFinal2 = CipherSpi.class.getDeclaredMethod("engineDoFinal", byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
            engineDoFinal2.setAccessible(true);
            engineDoFinal3 = CipherSpi.class.getDeclaredMethod("engineDoFinal", ByteBuffer.class, ByteBuffer.class);
            engineDoFinal3.setAccessible(true);
            engineWrap = CipherSpi.class.getDeclaredMethod("engineWrap", Key.class);
            engineWrap.setAccessible(true);
            engineUnwrap = CipherSpi.class.getDeclaredMethod("engineUnwrap", byte[].class, String.class, Integer.TYPE);
            engineUnwrap.setAccessible(true);
            engineGetKeySize = CipherSpi.class.getDeclaredMethod("engineGetKeySize", Key.class);
            engineGetKeySize.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load CipherSpi methods", exception);
        }
    }
}

