/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaCaret;
import ch.randelshofer.quaqua.QuaquaHighlighter;
import ch.randelshofer.quaqua.QuaquaTextCursorHandler;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class QuaquaEditorPaneUI
extends BasicEditorPaneUI
implements VisuallyLayoutable {
    boolean oldDragState = false;
    private MouseListener popupListener;

    public static ComponentUI createUI(JComponent jcomponent) {
        return new QuaquaEditorPaneUI();
    }

    protected void installListeners() {
        this.popupListener = this.createPopupListener();
        if (this.popupListener != null) {
            this.getComponent().addMouseListener(this.popupListener);
        }
        QuaquaTextCursorHandler.getInstance().installListeners(this.getComponent());
    }

    protected void uninstallListeners() {
        if (this.popupListener != null) {
            this.getComponent().removeMouseListener(this.popupListener);
            this.popupListener = null;
        }
        QuaquaTextCursorHandler.getInstance().uninstallListeners(this.getComponent());
    }

    protected MouseListener createPopupListener() {
        return (MouseListener)UIManager.get(this.getPropertyPrefix() + ".popupHandler");
    }

    protected void installDefaults() {
        if (!QuaquaUtilities.isHeadless()) {
            this.oldDragState = Methods.invokeGetter((Object)this.getComponent(), "getDragEnabled", true);
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", true);
        }
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        if (!QuaquaUtilities.isHeadless()) {
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", this.oldDragState);
        }
        super.uninstallDefaults();
    }

    protected void paintSafely(Graphics g) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        super.paintSafely(g);
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, this.getComponent(), this);
    }

    protected Caret createCaret() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        QuaquaCaret caret = new QuaquaCaret(window, this.getComponent());
        return caret;
    }

    protected Highlighter createHighlighter() {
        return new QuaquaHighlighter();
    }

    public Insets getVisualMargin(JTextComponent tc) {
        return new Insets(0, 0, 0, 0);
    }

    public int getBaseline(JComponent c, int width, int height) {
        JTextComponent tc = (JTextComponent)c;
        Insets insets = tc.getInsets();
        FontMetrics fm = tc.getFontMetrics(tc.getFont());
        return insets.top + fm.getAscent();
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JTextComponent b = (JTextComponent)c;
        if (type == 1 && b.getBorder() != null) {
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
                --bounds.height;
            }
        } else {
            bounds = this.getVisibleEditorRect();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = this.getBaseline(b, width, height);
            Rectangle textBounds = Fonts.getPerceivedBounds(b.getText(), b.getFont(), c);
            if (bounds == null) {
                bounds = textBounds;
                bounds.y += baseline;
            } else {
                bounds.y = baseline + textBounds.y;
                bounds.height = textBounds.height;
            }
            ++bounds.x;
            bounds.width -= 2;
        }
        return bounds;
    }
}

