/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessControlException;

public class OSXClipboardTransferable
implements Transferable {
    private static Boolean isNativeCodeAvailable;
    private static int EXPECTED_NATIVE_CODE_VERSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isNativeCodeAvailable() {
        if (isNativeCodeAvailable == null) {
            block17: {
                Class<OSXClipboardTransferable> clazz = OSXClipboardTransferable.class;
                // MONITORENTER : ch.randelshofer.quaqua.osx.OSXClipboardTransferable.class
                if (isNativeCodeAvailable == null) {
                    boolean success = false;
                    try {
                        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
                        if (value == null) {
                            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
                        }
                        String libraryName = null;
                        if (value != null && value.equals("true")) {
                            success = true;
                        } else {
                            libraryName = QuaquaManager.getOS() >= 5 && QuaquaManager.getProperty("os.arch").equals("x86_64") ? "quaqua64" : "quaqua";
                            try {
                                System.loadLibrary(libraryName);
                                success = true;
                            }
                            catch (UnsatisfiedLinkError e) {
                                System.err.println("Warning: " + OSXClipboardTransferable.class + " couldn't load library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                            catch (AccessControlException e) {
                                System.err.println("Warning: " + OSXClipboardTransferable.class + " access controller denied loading library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                System.err.println("Warning: " + OSXClipboardTransferable.class + " couldn't load library \"" + libraryName + "\". " + e);
                                success = false;
                            }
                        }
                        if (!success) break block17;
                        try {
                            int nativeCodeVersion = OSXClipboardTransferable.nativeGetNativeCodeVersion();
                            if (nativeCodeVersion != EXPECTED_NATIVE_CODE_VERSION) {
                                System.err.println("Warning: " + OSXClipboardTransferable.class + " can't use library " + libraryName + ". It has version " + nativeCodeVersion + " instead of " + EXPECTED_NATIVE_CODE_VERSION);
                                success = false;
                            }
                        }
                        catch (UnsatisfiedLinkError e) {
                            System.err.println("Warning: " + OSXClipboardTransferable.class + " could load library " + libraryName + " but can't use it. " + e);
                            success = false;
                        }
                    }
                    finally {
                        isNativeCodeAvailable = success;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (isNativeCodeAvailable != Boolean.TRUE) return false;
        return true;
    }

    private static native String[] nativeGetTypes();

    private static native byte[] nativeGetDataForType(String var0);

    private static native int nativeGetNativeCodeVersion();

    public DataFlavor[] getTransferDataFlavors() {
        String[] types = OSXClipboardTransferable.nativeGetTypes();
        if (types == null) {
            return new DataFlavor[0];
        }
        DataFlavor[] flavors = new DataFlavor[types.length];
        for (int i = 0; i < types.length; ++i) {
            try {
                flavors[i] = new DataFlavor("application/octet-stream; type=" + URLEncoder.encode(types[i], "UTF-8"), types[i]);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                InternalError ie = new InternalError("URLEncoder does not support UTF-8");
                ie.initCause(ex);
                throw ie;
            }
        }
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] f = this.getTransferDataFlavors();
        for (int i = 0; i < f.length; ++i) {
            if (!f[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == null) {
            throw new NullPointerException("flavor");
        }
        String type = URLDecoder.decode(flavor.getParameter("type"), "UTF-8");
        byte[] data = OSXClipboardTransferable.nativeGetDataForType(type);
        if (data == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream(data);
        }
        return data;
    }

    static {
        EXPECTED_NATIVE_CODE_VERSION = 2;
    }
}

