/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;

public class BitmapImageIO
extends Bitmap {
    private final boolean DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false)));

    public BitmapImageIO(IconEntry pEntry) throws IOException {
        super(pEntry);
    }

    protected BufferedImage createImage() throws IOException {
        ByteArrayOutputStream tmpout = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(tmpout);
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        out.writeByte(66);
        out.writeByte(77);
        out.writeInt(this.entry.getImageData().length + 14);
        out.writeShort(0);
        out.writeShort(0);
        out.writeInt(54);
        out.writeInt(this.biSize);
        out.writeInt(this.entry.getWidth());
        out.writeInt(this.entry.getHeight());
        out.writeShort(this.biPlanes);
        out.writeShort(this.biBitCount);
        out.writeInt(this.biCompression);
        out.writeInt(this.biSizeImage);
        out.writeInt(this.biXPelsPerMeter);
        out.writeInt(this.biYPelsPerMeter);
        out.writeInt(this.biColorsUsed);
        out.writeInt(this.biColorsImportant);
        out.write(this.entry.getImageData(), this.biSize, this.entry.getImageData().length - this.biSize);
        out.flush();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(tmpout.toByteArray());
        ImageInputStream input = ImageIO.createImageInputStream(in);
        BufferedImage res = null;
        IOException exToThrow = null;
        Iterator<ImageReader> it = ImageIO.getImageReaders(input);
        Class<?> bmpimagereaderClass = null;
        try {
            bmpimagereaderClass = Class.forName("com.sun.imageio.plugins.bmp.BMPImageReader");
        }
        catch (ClassNotFoundException ex1) {
            // empty catch block
        }
        while (it.hasNext()) {
            boolean isBMPImageReader = false;
            try {
                ImageReader r = it.next();
                boolean bl = isBMPImageReader = r.getClass() == bmpimagereaderClass;
                if (this.DEBUG) {
                    System.out.println("BitmapImageIO: Trying reader: " + r.getClass().getName());
                }
                r.setInput(input);
                res = r.read(0);
                break;
            }
            catch (IOException ex) {
                res = null;
                if (isBMPImageReader) {
                    exToThrow = ex;
                }
                in = new ByteArrayInputStream(tmpout.toByteArray());
                input = ImageIO.createImageInputStream(in);
            }
        }
        if (exToThrow != null && res == null) {
            throw exToThrow;
        }
        return res;
    }
}

