/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JLabel;

public final class FormDebugUtils {
    private FormDebugUtils() {
    }

    public static void dumpAll(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        FormDebugUtils.dumpColumnSpecs(formLayout);
        FormDebugUtils.dumpRowSpecs(formLayout);
        System.out.println();
        FormDebugUtils.dumpColumnGroups(formLayout);
        FormDebugUtils.dumpRowGroups(formLayout);
        System.out.println();
        FormDebugUtils.dumpConstraints(container);
        FormDebugUtils.dumpGridBounds(container);
    }

    public static void dumpColumnSpecs(FormLayout formLayout) {
        System.out.print("COLUMN SPECS:");
        for (int i = 1; i <= formLayout.getColumnCount(); ++i) {
            ColumnSpec columnSpec = formLayout.getColumnSpec(i);
            System.out.print(columnSpec.toShortString());
            if (i >= formLayout.getColumnCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpRowSpecs(FormLayout formLayout) {
        System.out.print("ROW SPECS:   ");
        for (int i = 1; i <= formLayout.getRowCount(); ++i) {
            RowSpec rowSpec = formLayout.getRowSpec(i);
            System.out.print(rowSpec.toShortString());
            if (i >= formLayout.getRowCount()) continue;
            System.out.print(", ");
        }
        System.out.println();
    }

    public static void dumpColumnGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("COLUMN GROUPS: ", formLayout.getColumnGroups());
    }

    public static void dumpRowGroups(FormLayout formLayout) {
        FormDebugUtils.dumpGroups("ROW GROUPS:    ", formLayout.getRowGroups());
    }

    public static void dumpGridBounds(Container container) {
        System.out.println("GRID BOUNDS");
        FormDebugUtils.dumpGridBounds(FormDebugUtils.getLayoutInfo(container));
    }

    public static void dumpGridBounds(FormLayout.LayoutInfo layoutInfo) {
        int n;
        System.out.print("COLUMN ORIGINS: ");
        for (n = 0; n < layoutInfo.columnOrigins.length; ++n) {
            System.out.print(layoutInfo.columnOrigins[n] + " ");
        }
        System.out.println();
        System.out.print("ROW ORIGINS:    ");
        for (n = 0; n < layoutInfo.rowOrigins.length; ++n) {
            System.out.print(layoutInfo.rowOrigins[n] + " ");
        }
        System.out.println();
    }

    public static void dumpConstraints(Container container) {
        System.out.println("COMPONENT CONSTRAINTS");
        if (!(container.getLayout() instanceof FormLayout)) {
            System.out.println("The container's layout is not a FormLayout.");
            return;
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            CellConstraints cellConstraints = formLayout.getConstraints(component);
            String string = cellConstraints == null ? "no constraints" : cellConstraints.toShortString(formLayout);
            System.out.print(string);
            System.out.print("; ");
            String string2 = component.getClass().getName();
            System.out.print(string2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                System.out.print("      \"" + jLabel.getText() + "\"");
            }
            if (component.getName() != null) {
                System.out.print("; name=");
                System.out.print(component.getName());
            }
            System.out.println();
        }
        System.out.println();
    }

    private static void dumpGroups(String string, int[][] nArray) {
        System.out.print(string + " {");
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            System.out.print(" {");
            for (int j = 0; j < nArray2.length; ++j) {
                System.out.print(nArray2[j]);
                if (j >= nArray2.length - 1) continue;
                System.out.print(", ");
            }
            System.out.print("} ");
            if (i >= nArray.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public static FormLayout.LayoutInfo getLayoutInfo(Container container) {
        if (!(container.getLayout() instanceof FormLayout)) {
            throw new IllegalArgumentException("The container must use an instance of FormLayout.");
        }
        FormLayout formLayout = (FormLayout)container.getLayout();
        return formLayout.getLayoutInfo(container);
    }
}

