/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceConstants {

    public static enum SubstanceWidgetType {
        MENU_SEARCH,
        TITLE_PANE_HEAP_STATUS;

    }

    public static enum TabContentPaneBorderKind {
        DOUBLE_FULL,
        SINGLE_FULL,
        DOUBLE_PLACEMENT,
        SINGLE_PLACEMENT;

    }

    public static enum MenuGutterFillKind {
        NONE,
        SOFT_FILL,
        HARD_FILL,
        SOFT,
        HARD;

    }

    public static enum ScrollPaneButtonPolicyKind {
        NONE,
        OPPOSITE,
        ADJACENT,
        MULTIPLE,
        MULTIPLE_BOTH;

    }

    public static enum TabCloseKind {
        NONE,
        THIS,
        ALL,
        ALL_BUT_THIS;

    }

    public static enum ImageWatermarkKind {
        SCREEN_CENTER_SCALE,
        SCREEN_TILE,
        APP_ANCHOR,
        APP_CENTER,
        APP_TILE;

    }

    public static enum FocusKind {
        NONE{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
            }
        }
        ,
        TEXT{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (rectangle == null) {
                    return;
                }
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                int n2 = SubstanceSizeUtils.getComponentFontSize(component);
                float f = 2.getDashLength(n2);
                float f2 = 2.getDashGap(n2);
                float f3 = (f + f2) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n2), 0, 1, 0.0f, new float[]{f, f2}, f3));
                int n3 = component instanceof JComboBox || component instanceof JSpinner ? 0 : 1;
                GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(rectangle.width + 2 * n3, rectangle.height, SubstanceSizeUtils.getClassicButtonCornerRadius(n2), null);
                graphics2D.translate(rectangle.x - n3, rectangle.y);
                graphics2D.draw(generalPath);
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (shape == null && component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                    SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(component);
                    if (substanceButtonShaper == null) {
                        return;
                    }
                    int n2 = SubstanceSizeUtils.getComponentFontSize(component);
                    float f = 3.getDashLength(n2);
                    float f2 = 3.getDashGap(n2);
                    float f3 = (f + f2) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n2), 0, 1, 0.0f, new float[]{f, f2}, f3));
                    Shape shape2 = substanceButtonShaper.getButtonOutline((AbstractButton)component, null, component.getWidth(), component.getHeight(), false);
                    graphics2D.draw(shape2);
                } else {
                    graphics2D.translate(1, 1);
                    Shape shape3 = shape != null ? shape : SubstanceOutlineUtilities.getBaseOutline(component.getWidth() - 2, component.getHeight() - 2, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(component)), null);
                    int n3 = SubstanceSizeUtils.getComponentFontSize(component);
                    float f = 3.getDashLength(n3);
                    float f4 = 3.getDashGap(n3);
                    float f5 = (f + f4) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n3), 0, 1, 0.0f, new float[]{f, f4}, f5));
                    graphics2D.draw(shape3);
                }
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_INNER{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (shape == null && component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                    SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(component);
                    if (substanceButtonShaper == null) {
                        return;
                    }
                    if (substanceButtonShaper.isProportionate()) {
                        int n2 = SubstanceSizeUtils.getComponentFontSize(component);
                        float f = 4.getDashLength(n2);
                        float f2 = 4.getDashGap(n2);
                        float f3 = (f + f2) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                        float f4 = SubstanceSizeUtils.getFocusStrokeWidth(n2);
                        graphics2D.setStroke(new BasicStroke(f4, 0, 1, 0.0f, new float[]{f, f2}, f3));
                        int n3 = n;
                        Insets insets = new Insets(n3, n3, n3, n3);
                        Shape shape2 = substanceButtonShaper.getButtonOutline((AbstractButton)component, insets, component.getWidth(), component.getHeight(), false);
                        graphics2D.draw(shape2);
                    }
                } else {
                    graphics2D.translate(n / 2, n / 2);
                    int n4 = SubstanceSizeUtils.getComponentFontSize(component);
                    Shape shape3 = shape != null ? shape : SubstanceOutlineUtilities.getBaseOutline(component.getWidth() - n, component.getHeight() - n, SubstanceSizeUtils.getClassicButtonCornerRadius(n4), null);
                    float f = 4.getDashLength(n4);
                    float f5 = 4.getDashGap(n4);
                    float f6 = (f + f5) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                    graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n4), 0, 1, 0.0f, new float[]{f, f5}, f6));
                    graphics2D.draw(shape3);
                }
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        ALL_STRONG_INNER{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (shape == null && component instanceof AbstractButton && !(component instanceof JCheckBox) && !(component instanceof JRadioButton)) {
                    SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(component);
                    if (substanceButtonShaper == null) {
                        return;
                    }
                    if (substanceButtonShaper.isProportionate()) {
                        Insets insets = new Insets(n, n, n, n);
                        Shape shape2 = substanceButtonShaper.getButtonOutline((AbstractButton)component, insets, component.getWidth(), component.getHeight(), false);
                        graphics2D.draw(shape2);
                    }
                } else {
                    graphics2D.translate(n / 2, n / 2);
                    Shape shape3 = shape != null ? shape : SubstanceOutlineUtilities.getBaseOutline(component.getWidth() - n, component.getHeight() - n, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(component)), null);
                    graphics2D.draw(shape3);
                }
            }
        }
        ,
        UNDERLINE{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (rectangle == null) {
                    return;
                }
                int n2 = SubstanceSizeUtils.getComponentFontSize(component);
                float f = 6.getDashLength(n2);
                float f2 = 6.getDashGap(n2);
                float f3 = (f + f2) * (1.0f - transitionAwareUI.getTransitionTracker().getFocusLoopPosition());
                graphics2D.setStroke(new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n2), 0, 1, 0.0f, new float[]{f, f2}, f3));
                graphics2D.translate(rectangle.x - 1, rectangle.y);
                graphics2D.drawLine(0, rectangle.height - 1, rectangle.width, rectangle.height - 1);
                graphics2D.dispose();
            }

            @Override
            public boolean isAnimated() {
                return true;
            }
        }
        ,
        STRONG_UNDERLINE{

            @Override
            public void paintFocus(Component component, Component component2, TransitionAwareUI transitionAwareUI, Graphics2D graphics2D, Shape shape, Rectangle rectangle, int n) {
                if (rectangle == null) {
                    return;
                }
                graphics2D.translate(rectangle.x - 1, rectangle.y);
                graphics2D.drawLine(0, rectangle.height - 1, rectangle.width, rectangle.height - 1);
            }
        };


        public abstract void paintFocus(Component var1, Component var2, TransitionAwareUI var3, Graphics2D var4, Shape var5, Rectangle var6, int var7);

        protected static float getDashLength(int n) {
            return 2.0f + (float)SubstanceSizeUtils.getExtraPadding(n);
        }

        protected static float getDashGap(int n) {
            return FocusKind.getDashLength(n) / 2.0f;
        }

        public boolean isAnimated() {
            return false;
        }
    }

    public static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

