/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter;

import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.trait.SubstanceTrait;

public abstract class FractionBasedPainter
implements SubstanceTrait {
    private String displayName;
    protected float[] fractions;
    protected ColorSchemeSingleColorQuery[] colorQueries;

    public FractionBasedPainter(String string, float[] fArray, ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray) {
        int n;
        this.displayName = string;
        if (fArray == null || colorSchemeSingleColorQueryArray == null) {
            throw new IllegalArgumentException("Cannot pass null arguments");
        }
        if (fArray.length != colorSchemeSingleColorQueryArray.length) {
            throw new IllegalArgumentException("Argument length does not match");
        }
        int n2 = fArray.length;
        if (fArray[0] != 0.0f || fArray[n2 - 1] != 1.0f) {
            throw new IllegalArgumentException("End fractions must be 0.0 and 1.0");
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (!(fArray[n + 1] <= fArray[n])) continue;
            throw new IllegalArgumentException("Fractions must be strictly increasing");
        }
        for (n = 0; n < n2; ++n) {
            if (colorSchemeSingleColorQueryArray[n] != null) continue;
            throw new IllegalArgumentException("Cannot pass null query");
        }
        this.colorQueries = new ColorSchemeSingleColorQuery[n2];
        System.arraycopy(colorSchemeSingleColorQueryArray, 0, this.colorQueries, 0, n2);
        this.fractions = new float[n2];
        System.arraycopy(fArray, 0, this.fractions, 0, n2);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public float[] getFractions() {
        float[] fArray = new float[this.fractions.length];
        System.arraycopy(this.fractions, 0, fArray, 0, this.fractions.length);
        return fArray;
    }

    public ColorSchemeSingleColorQuery[] getColorQueries() {
        ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray = new ColorSchemeSingleColorQuery[this.colorQueries.length];
        System.arraycopy(this.colorQueries, 0, colorSchemeSingleColorQueryArray, 0, this.colorQueries.length);
        return colorSchemeSingleColorQueryArray;
    }
}

