/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.FractionBasedPainter;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class FractionBasedBorderPainter
extends FractionBasedPainter
implements SubstanceBorderPainter {
    public FractionBasedBorderPainter(String string, float[] fArray, ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray) {
        super(string, fArray, colorSchemeSingleColorQueryArray);
    }

    @Override
    public void paintBorder(Graphics graphics, Component component, int n, int n2, Shape shape, Shape shape2, SubstanceColorScheme substanceColorScheme) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Color[] colorArray = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorSchemeSingleColorQuery = this.colorQueries[i];
            colorArray[i] = colorSchemeSingleColorQuery.query(substanceColorScheme);
        }
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        boolean bl = component instanceof SubstanceInternalArrowButton;
        int n3 = bl ? 0 : 1;
        int n4 = bl ? 2 : 0;
        graphics2D.setStroke(new BasicStroke(f, n4, n3));
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, this.fractions, colorArray, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.draw(shape);
        graphics2D.dispose();
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }
}

