/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class ArcDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Arc";

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        if (decorationAreaType == DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics2D, component, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        } else {
            this.paintExtraBackground(graphics2D, SubstanceCoreUtilities.getHeaderParent(component), component, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        }
    }

    private void paintTitleBackground(Graphics2D graphics2D, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(n, 0.0f);
        generalPath.lineTo(n, n2 / 2);
        generalPath.quadTo(n / 2, n2 / 4, 0.0f, n2 / 2);
        generalPath.lineTo(0.0f, 0.0f);
        graphics2D2.setClip(generalPath);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{substanceColorScheme.getLightColor(), substanceColorScheme.getUltraLightColor(), substanceColorScheme.getLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D2.setPaint(linearGradientPaint);
        graphics2D2.fillRect(0, 0, n, n2);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(0.0f, n2);
        generalPath2.lineTo(n, n2);
        generalPath2.lineTo(n, n2 / 2);
        generalPath2.quadTo(n / 2, n2 / 4, 0.0f, n2 / 2);
        generalPath2.lineTo(0.0f, n2);
        graphics2D2.setClip(generalPath2);
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{substanceColorScheme.getMidColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D2.setPaint(linearGradientPaint2);
        graphics2D2.fillRect(0, 0, n, n2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(n, n2 / 2);
        generalPath3.quadTo(n / 2, n2 / 4, 0.0f, n2 / 2);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setClip(new Rectangle(0, 0, n, n2));
        graphics2D2.draw(generalPath3);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
    }

    private void paintExtraBackground(Graphics2D graphics2D, Container container, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        int n3;
        Point point = SubstancePainterUtils.getOffsetInRootPaneCoords(component);
        JRootPane jRootPane = SwingUtilities.getRootPane(container);
        JComponent jComponent = null;
        if (jRootPane != null) {
            jComponent = SubstanceCoreUtilities.getTitlePane(jRootPane);
        }
        int n4 = n3 = jComponent == null ? container.getWidth() : jComponent.getWidth();
        if (n3 != 0) {
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(-point.x, 0.0f, -point.x + n3, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{substanceColorScheme.getMidColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setPaint(linearGradientPaint);
            graphics2D2.fillRect(-point.x, 0, n3, n2);
            graphics2D2.dispose();
        }
    }
}

