/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public final class BottomShadowOverlayPainter
implements SubstanceOverlayPainter {
    private static BottomShadowOverlayPainter INSTANCE;

    public static synchronized BottomShadowOverlayPainter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BottomShadowOverlayPainter();
        }
        return INSTANCE;
    }

    private BottomShadowOverlayPainter() {
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Color color = SubstanceColorUtilities.getBackgroundFillColor(component).darker();
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        int n3 = component2.getHeight();
        Point point = SwingUtilities.convertPoint(component, new Point(0, 0), component2);
        int n4 = point.y;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(0, -n4);
        int n5 = 4;
        GradientPaint gradientPaint = new GradientPaint(0.0f, n3 - n5, SubstanceColorUtilities.getAlphaColor(color, 0), 0.0f, n3, SubstanceColorUtilities.getAlphaColor(color, 128));
        graphics2D2.setPaint(gradientPaint);
        graphics2D2.fillRect(0, n3 - n5, n, n5);
        graphics2D2.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Bottom Shadow";
    }
}

