/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class TopLineOverlayPainter
implements SubstanceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public TopLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeSingleColorQuery) {
        this.colorSchemeQuery = colorSchemeSingleColorQuery;
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        Point point = SwingUtilities.convertPoint(component, new Point(0, 0), component2);
        int n3 = point.y;
        int n4 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n4);
        graphics2D.setStroke(new BasicStroke(f));
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        graphics2D.setColor(this.colorSchemeQuery.query(substanceColorScheme));
        graphics2D.drawLine(0, (int)f - n3 - 1, n, (int)f - n3 - 1);
    }

    @Override
    public String getDisplayName() {
        return "Top Line";
    }
}

