/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelinePropertyBuilder;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public class SubstanceProgressBarUI
extends BasicProgressBarUI {
    protected Set lafWidgets;
    private static final ComponentState DETERMINATE_SELECTED = new ComponentState("determinate enabled", new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.DETERMINATE, ComponentStateFacet.SELECTION}, null);
    private static final ComponentState DETERMINATE_SELECTED_DISABLED = new ComponentState("determinate disabled", new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE, ComponentStateFacet.SELECTION}, new ComponentStateFacet[]{ComponentStateFacet.ENABLE});
    private static final ComponentState INDETERMINATE_SELECTED = new ComponentState("indeterminate enabled", new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.SELECTION}, new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE});
    private static final ComponentState INDETERMINATE_SELECTED_DISABLED = new ComponentState("indeterminate disabled", null, new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE, ComponentStateFacet.ENABLE, ComponentStateFacet.SELECTION});
    private static LazyResettableHashMap<BufferedImage> stripeMap = new LazyResettableHashMap("SubstanceProgressBarUI.stripeMap");
    private static LazyResettableHashMap<BufferedImage> backgroundMap = new LazyResettableHashMap("SubstanceProgressBarUI.backgroundMap");
    private float animationPosition;
    protected ChangeListener substanceValueChangeListener;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected int margin;
    protected float speed;
    protected int displayedValue;
    protected Timeline displayTimeline;
    protected Timeline indeterminateLoopTimeline;

    public void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceProgressBarUI();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installDefaults() {
        super.installDefaults();
        this.displayedValue = this.progressBar.getValue();
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.speed = 20.0f * (float)UIManager.getInt("ProgressBar.repaintInterval") / (float)UIManager.getInt("ProgressBar.cycleTime");
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.progressBar));
        this.margin = (int)Math.ceil(1.5 * (double)f);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__installListeners() {
        super.installListeners();
        this.substanceValueChangeListener = new SubstanceChangeListener();
        this.progressBar.addChangeListener(this.substanceValueChangeListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceProgressBarUI.this.progressBar != null) {
                                SubstanceProgressBarUI.this.progressBar.updateUI();
                            }
                        }
                    });
                }
            }
        };
        this.progressBar.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceProgressBarUI__uninstallListeners() {
        this.progressBar.removeChangeListener(this.substanceValueChangeListener);
        this.substanceValueChangeListener = null;
        this.progressBar.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    private static BufferedImage getStripe(int n, boolean bl, SubstanceColorScheme substanceColorScheme) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, bl, substanceColorScheme.getDisplayName());
        BufferedImage bufferedImage = stripeMap.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceImageCreator.getStripe(n, substanceColorScheme.getUltraLightColor());
            if (bl) {
                bufferedImage = SubstanceImageCreator.getRotated(bufferedImage, 1);
            }
            stripeMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    private static BufferedImage getDeterminateBackground(JProgressBar jProgressBar, int n, int n2, SubstanceColorScheme substanceColorScheme, SubstanceFillPainter substanceFillPainter, int n3, ComponentOrientation componentOrientation) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme.getDisplayName(), substanceFillPainter.getDisplayName(), n3, componentOrientation);
        BufferedImage bufferedImage = backgroundMap.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, 0.0f, null);
            substanceFillPainter.paintContourBackground(graphics2D, jProgressBar, n, n2, generalPath, false, substanceColorScheme, true);
            graphics2D.dispose();
            if (n3 == 1) {
                bufferedImage = componentOrientation.isLeftToRight() ? SubstanceImageCreator.getRotated(bufferedImage, 3) : SubstanceImageCreator.getRotated(bufferedImage, 1);
            }
            backgroundMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    public void paintDeterminate(Graphics graphics, JComponent jComponent) {
        BufferedImage bufferedImage;
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        ComponentState componentState = this.getFillState();
        ComponentState componentState2 = this.getProgressState();
        int n = this.progressBar.getWidth() - 2 * this.margin;
        int n2 = this.progressBar.getHeight() - 2 * this.margin;
        int n3 = this.getAmountFull(new Insets(this.margin, this.margin, this.margin, this.margin), n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = SubstanceColorSchemeUtilities.getAlpha(this.progressBar, componentState);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.progressBar, f, graphics));
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, componentState);
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            bufferedImage = SubstanceProgressBarUI.getDeterminateBackground(this.progressBar, n + 1, n2 + 1, substanceColorScheme, substanceFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            graphics2D.drawImage((Image)bufferedImage, this.margin, this.margin, null);
        } else {
            bufferedImage = SubstanceProgressBarUI.getDeterminateBackground(this.progressBar, n2 + 1, n + 1, substanceColorScheme, substanceFillPainter, this.progressBar.getOrientation(), this.progressBar.getComponentOrientation());
            graphics2D.drawImage((Image)bufferedImage, this.margin, this.margin, null);
        }
        if (n3 > 0) {
            int n4 = 0;
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, componentState2);
            if (this.progressBar.getOrientation() == 0) {
                int n5 = n3 - 2 * n4;
                int n6 = n2 - 2 * n4;
                if (n5 > 0 && n6 > 0) {
                    if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                        SubstanceImageCreator.paintRectangularBackground(this.progressBar, graphics, this.margin + n4, this.margin + n4, n5, n6, substanceColorScheme2, 0.6f, false);
                    } else {
                        SubstanceImageCreator.paintRectangularBackground(this.progressBar, graphics, this.margin + n - n3 - 2 * n4, this.margin + n4, n5, n6, substanceColorScheme2, 0.6f, false);
                    }
                }
            } else {
                int n7 = n3 - 2 * n4;
                int n8 = n - 2 * n4;
                if (n3 > 0 && n8 > 0) {
                    SubstanceImageCreator.paintRectangularBackground(this.progressBar, graphics, this.margin + n4, this.margin + n2 - n7 - n4, n8, n7, substanceColorScheme2, 0.6f, true);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, graphics));
            this.paintString(graphics2D, this.margin, this.margin, n, n2, n3, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        graphics2D.dispose();
    }

    @Override
    protected Color getSelectionBackground() {
        ComponentState componentState = this.getFillState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, componentState);
        return SubstanceColorUtilities.getForegroundColor(substanceColorScheme);
    }

    @Override
    protected Color getSelectionForeground() {
        ComponentState componentState = this.getProgressState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, componentState);
        return SubstanceColorUtilities.getForegroundColor(substanceColorScheme);
    }

    @Override
    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        ComponentState componentState = this.getProgressState();
        int n = this.progressBar.getWidth() - 2 * this.margin;
        int n2 = this.progressBar.getHeight() - 2 * this.margin;
        int n3 = 0;
        n3 = this.progressBar.getOrientation() == 0 ? (int)(this.animationPosition * (float)(2 * n2 + 1)) : (int)(this.animationPosition * (float)(2 * n + 1));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float f = SubstanceColorSchemeUtilities.getAlpha(this.progressBar, componentState);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.progressBar, f, graphics));
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.progressBar, componentState);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(this.progressBar, graphics2D, this.margin, this.margin, n, n2, substanceColorScheme, SubstanceProgressBarUI.getStripe(n2, false, substanceColorScheme), n3, 0.6f, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(this.progressBar, graphics2D, this.margin, this.margin, n, n2, substanceColorScheme, SubstanceProgressBarUI.getStripe(n, true, substanceColorScheme), 2 * n - n3, 0.6f, true);
        }
        if (this.progressBar.isStringPainted()) {
            graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(this.progressBar, 1.0f, graphics));
            this.paintString(graphics2D, this.margin, this.margin, n, n2, n, new Insets(this.margin, this.margin, this.margin, this.margin));
        }
        graphics2D.dispose();
    }

    private ComponentState getFillState() {
        return this.progressBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
    }

    private ComponentState getProgressState() {
        if (this.progressBar.isIndeterminate()) {
            return this.progressBar.isEnabled() ? INDETERMINATE_SELECTED : INDETERMINATE_SELECTED_DISABLED;
        }
        return this.progressBar.isEnabled() ? DETERMINATE_SELECTED : DETERMINATE_SELECTED_DISABLED;
    }

    @Override
    protected Rectangle getBox(Rectangle rectangle) {
        int n = this.progressBar.getWidth() - 2 * this.margin;
        int n2 = this.progressBar.getHeight() - 2 * this.margin;
        return new Rectangle(this.margin, this.margin, n, n2);
    }

    @Override
    protected void startAnimationTimer() {
        this.indeterminateLoopTimeline = new Timeline((Object)this);
        Integer n = UIManager.getInt("ProgressBar.cycleTime");
        if (n == null) {
            n = 1000;
        }
        this.indeterminateLoopTimeline.setDuration((long)n.intValue());
        this.indeterminateLoopTimeline.addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                if (SubstanceProgressBarUI.this.progressBar != null && SubstanceProgressBarUI.this.progressBar.isVisible()) {
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }

            public void onTimelinePulse(float f, float f2) {
                if (SubstanceProgressBarUI.this.progressBar != null && SubstanceProgressBarUI.this.progressBar.isVisible()) {
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }
        });
        this.indeterminateLoopTimeline.addPropertyToInterpolate(Timeline.property((String)"animationPosition").from((Object)Float.valueOf(0.0f)).to((Object)Float.valueOf(1.0f)).setWith((TimelinePropertyBuilder.PropertySetter)new TimelinePropertyBuilder.PropertySetter<Float>(){

            public void set(Object object, String string, Float f) {
                SubstanceProgressBarUI.this.animationPosition = f.floatValue();
            }
        }));
        this.indeterminateLoopTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
    }

    @Override
    protected void stopAnimationTimer() {
        this.indeterminateLoopTimeline.abort();
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceProgressBarUI: \n");
        stringBuffer.append("\t" + stripeMap.size() + " stripes");
        return stringBuffer.toString();
    }

    @Override
    protected int getAmountFull(Insets insets, int n, int n2) {
        int n3 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        long l = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
        double d = (double)(this.displayedValue - boundedRangeModel.getMinimum()) / (double)l;
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n3 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n * d) : (int)Math.round((double)n2 * d);
        }
        return n3;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        int n = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        n += 2 * SubstanceSizeUtils.getAdjustedSize(n, 1, 4, 1, false);
        return new Dimension(146 + SubstanceSizeUtils.getAdjustedSize(n, 0, 1, 10, false), n);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        int n = SubstanceSizeUtils.getComponentFontSize(this.progressBar);
        n += 2 * SubstanceSizeUtils.getAdjustedSize(n, 1, 4, 1, false);
        return new Dimension(n, 146 + SubstanceSizeUtils.getAdjustedSize(n, 0, 1, 10, false));
    }

    @Override
    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, Insets insets) {
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(graphics, n, n2, n3, n4, this.boxRect.x, this.boxRect.width, insets);
                } else {
                    this.paintString(graphics, n, n2, n3, n4, n, n5, insets);
                }
            } else {
                this.paintString(graphics, n, n2, n3, n4, n + n3 - n5, n5, insets);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(graphics, n, n2, n3, n4, this.boxRect.y, this.boxRect.height, insets);
        } else {
            this.paintString(graphics, n, n2, n3, n4, n2 + n4 - n5, n5, insets);
        }
    }

    private void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        String string = this.progressBar.getString();
        Rectangle rectangle = this.getStringRectangle(string, n, n2, n3, n4);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceTextUtilities.paintText(graphics, this.progressBar, rectangle, string, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(n6, n2, this.progressBar.getWidth() - n6, n4));
            SubstanceTextUtilities.paintText(graphics, this.progressBar, rectangle, string, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(n5, n2, n6, n4));
        } else {
            SubstanceTextUtilities.paintVerticalText(graphics, this.progressBar, rectangle, string, -1, this.progressBar.getFont(), this.getSelectionBackground(), new Rectangle(n, n2, n3, this.progressBar.getHeight() - n6), this.progressBar.getComponentOrientation().isLeftToRight());
            SubstanceTextUtilities.paintVerticalText(graphics, this.progressBar, rectangle, string, -1, this.progressBar.getFont(), this.getSelectionForeground(), new Rectangle(n, n5, n3, n6), this.progressBar.getComponentOrientation().isLeftToRight());
        }
    }

    protected Rectangle getStringRectangle(String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n5 = fontMetrics.stringWidth(string);
        if (this.progressBar.getOrientation() == 0) {
            return new Rectangle(n + Math.round(n3 / 2 - n5 / 2), n2 + (n4 - fontMetrics.getHeight()) / 2, n5, fontMetrics.getHeight());
        }
        return new Rectangle(n + (n3 - fontMetrics.getHeight()) / 2, n2 + Math.round(n4 / 2 - n5 / 2), fontMetrics.getHeight(), n5);
    }

    private final class SubstanceChangeListener
    implements ChangeListener {
        private SubstanceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl;
            int n;
            SubstanceCoreUtilities.testComponentStateChangeThreadingViolation(SubstanceProgressBarUI.this.progressBar);
            int n2 = SubstanceProgressBarUI.this.progressBar.getValue();
            int n3 = SubstanceProgressBarUI.this.progressBar.getMaximum() - SubstanceProgressBarUI.this.progressBar.getMinimum();
            int n4 = SubstanceProgressBarUI.this.progressBar.getWidth() - 2 * SubstanceProgressBarUI.this.margin;
            int n5 = SubstanceProgressBarUI.this.progressBar.getHeight() - 2 * SubstanceProgressBarUI.this.margin;
            int n6 = SubstanceProgressBarUI.this.progressBar.getOrientation() == 0 ? n4 : n5;
            int n7 = n = n3 <= 0 ? 0 : (n2 - SubstanceProgressBarUI.this.displayedValue) * n6 / n3;
            if (SubstanceProgressBarUI.this.displayTimeline != null) {
                SubstanceProgressBarUI.this.displayTimeline.abort();
            }
            SubstanceProgressBarUI.this.displayTimeline = new Timeline((Object)SubstanceProgressBarUI.this.progressBar);
            SubstanceProgressBarUI.this.displayTimeline.addPropertyToInterpolate(Timeline.property((String)"displayedValue").from((Object)SubstanceProgressBarUI.this.displayedValue).to((Object)n2).setWith((TimelinePropertyBuilder.PropertySetter)new TimelinePropertyBuilder.PropertySetter<Integer>(){

                public void set(Object object, String string, Integer n) {
                    SubstanceProgressBarUI.this.displayedValue = n;
                    SubstanceProgressBarUI.this.progressBar.repaint();
                }
            }));
            SubstanceProgressBarUI.this.displayTimeline.setEase((TimelineEase)new Spline(0.4f));
            AnimationConfigurationManager.getInstance().configureTimeline(SubstanceProgressBarUI.this.displayTimeline);
            boolean bl2 = bl = SwingUtilities.getAncestorOfClass(CellRendererPane.class, SubstanceProgressBarUI.this.progressBar) != null;
            if (!bl && Math.abs(n) > 5) {
                SubstanceProgressBarUI.this.displayTimeline.play();
            } else {
                SubstanceProgressBarUI.this.displayedValue = n2;
                SubstanceProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

