/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSpinnerButton;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceSpinnerUI
extends BasicSpinnerUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected SubstanceSpinnerButton nextButton;
    protected SubstanceSpinnerButton prevButton;

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceSpinnerUI();
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JSpinner>(){

            @Override
            public JTextComponent getTextComponent(JSpinner jSpinner) {
                JComponent jComponent = jSpinner.getEditor();
                if (jComponent != null && jComponent instanceof JSpinner.DefaultEditor) {
                    return ((JSpinner.DefaultEditor)jComponent).getTextField();
                }
                return null;
            }
        });
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallUI(JComponent jComponent) {
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(jComponent);
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = new SubstanceSpinnerButton(this.spinner, 1);
        this.nextButton.setFont(this.spinner.getFont());
        this.nextButton.setName("Spinner.nextButton");
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.nextButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.nextButton);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(n), SubstanceSizeUtils.getSpinnerArrowIconHeight(n), SubstanceSizeUtils.getArrowStrokeWidth(n), 1, substanceColorScheme);
            }
        }, "substance.spinner.nextButton");
        this.nextButton.setIcon(transitionAwareIcon);
        int n = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.spinner));
        this.nextButton.setPreferredSize(new Dimension(n, n));
        this.nextButton.setMinimumSize(new Dimension(5, 5));
        this.nextButton.putClientProperty("substancelaf.buttonopenSide", EnumSet.of(SubstanceConstants.Side.BOTTOM));
        this.nextButton.putClientProperty("substancelaf.buttonside", EnumSet.of(SubstanceConstants.Side.BOTTOM));
        this.installNextButtonListeners(this.nextButton);
        Color color = this.spinner.getBackground();
        if (!(color instanceof UIResource)) {
            this.nextButton.setBackground(color);
        }
        return this.nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = new SubstanceSpinnerButton(this.spinner, 5);
        this.prevButton.setFont(this.spinner.getFont());
        this.prevButton.setName("Spinner.previousButton");
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.prevButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                int n = SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.prevButton);
                float f = SubstanceSizeUtils.getSpinnerArrowIconHeight(n);
                return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSpinnerArrowIconWidth(n), f, SubstanceSizeUtils.getArrowStrokeWidth(n), 5, substanceColorScheme);
            }
        }, "substance.spinner.prevButton");
        this.prevButton.setIcon(transitionAwareIcon);
        int n = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.prevButton));
        this.prevButton.setPreferredSize(new Dimension(n, n));
        this.prevButton.setMinimumSize(new Dimension(5, 5));
        this.prevButton.putClientProperty("substancelaf.buttonopenSide", EnumSet.of(SubstanceConstants.Side.TOP));
        this.prevButton.putClientProperty("substancelaf.buttonside", EnumSet.of(SubstanceConstants.Side.TOP));
        this.installPreviousButtonListeners(this.prevButton);
        Color color = this.spinner.getBackground();
        if (!(color instanceof UIResource)) {
            this.nextButton.setBackground(color);
        }
        return this.prevButton;
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installDefaults() {
        Object object;
        super.installDefaults();
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent != null && jComponent instanceof JSpinner.DefaultEditor && (object = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
            int n = SubstanceSizeUtils.getComponentFontSize(this.spinner);
            Insets insets = SubstanceSizeUtils.getSpinnerTextBorderInsets(n);
            ((JComponent)object).setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            ((JTextField)object).setFont(this.spinner.getFont());
            ((JComponent)object).setOpaque(false);
        }
        if (jComponent != null) {
            jComponent.setOpaque(false);
        }
        if ((object = this.spinner.getBorder()) == null || object instanceof UIResource) {
            this.spinner.setBorder(new SubstanceTextComponentBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.spinner))));
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editor".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JFormattedTextField jFormattedTextField;
                            if (SubstanceSpinnerUI.this.spinner == null) {
                                return;
                            }
                            JComponent jComponent = SubstanceSpinnerUI.this.spinner.getEditor();
                            if (jComponent != null && jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
                                Insets insets = SubstanceSizeUtils.getSpinnerTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
                                jFormattedTextField.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                                jFormattedTextField.revalidate();
                            }
                        }
                    });
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceSpinnerUI.this.spinner != null) {
                                SubstanceSpinnerUI.this.spinner.updateUI();
                            }
                        }
                    });
                }
                if ("background".equals(propertyChangeEvent.getPropertyName())) {
                    JFormattedTextField jFormattedTextField;
                    JComponent jComponent = SubstanceSpinnerUI.this.spinner.getEditor();
                    if (jComponent != null && jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
                        Color color = jFormattedTextField.getBackground();
                        boolean bl = SubstanceCoreUtilities.canReplaceChildBackgroundColor(color);
                        if (SubstanceSpinnerUI.this.spinner.getBackground() == null) {
                            bl = false;
                        }
                        if (bl) {
                            jFormattedTextField.setBackground(new SubstanceColorResource(SubstanceSpinnerUI.this.spinner.getBackground()));
                        }
                    }
                    SubstanceSpinnerUI.this.nextButton.setBackground(SubstanceSpinnerUI.this.spinner.getBackground());
                    SubstanceSpinnerUI.this.prevButton.setBackground(SubstanceSpinnerUI.this.spinner.getBackground());
                }
            }
        };
        this.spinner.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__uninstallListeners() {
        this.spinner.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = this.spinner.getWidth();
        int n2 = this.spinner.getHeight();
        int n3 = SubstanceSizeUtils.getComponentFontSize(this.spinner);
        int n4 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n3));
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(n3) - (float)n4), null, n4);
        graphics2D.setColor(SubstanceTextUtilities.getTextBackgroundFillColor(this.spinner));
        graphics2D.fill(generalPath);
        graphics2D.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.nextButton.getPreferredSize();
        Dimension dimension2 = this.prevButton.getPreferredSize();
        Dimension dimension3 = this.spinner.getEditor().getPreferredSize();
        Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
        dimension4.width += Math.max(dimension.width, dimension2.width);
        Insets insets = this.spinner.getInsets();
        dimension4.width += insets.left + insets.right;
        dimension4.height += insets.top + insets.bottom;
        return dimension4;
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceSpinnerUI__update(Graphics graphics, JComponent jComponent) {
        SubstanceTextUtilities.paintTextCompBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayoutManager();
    }

    protected class SpinnerLayoutManager
    implements LayoutManager {
        protected SpinnerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension dimension2 = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            Dimension dimension3 = SubstanceSpinnerUI.this.spinner.getEditor().getPreferredSize();
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            Insets insets2 = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            dimension4.width += insets2.left + insets2.right;
            return dimension4;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4 = container.getWidth();
            int n5 = container.getHeight();
            Insets insets = container.getInsets();
            Dimension dimension = SubstanceSpinnerUI.this.nextButton.getPreferredSize();
            Dimension dimension2 = SubstanceSpinnerUI.this.prevButton.getPreferredSize();
            int n6 = Math.max(dimension.width, dimension2.width);
            int n7 = n5 - (insets.top + insets.bottom);
            Insets insets2 = SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getComponentFontSize(SubstanceSpinnerUI.this.spinner));
            if (container.getComponentOrientation().isLeftToRight()) {
                n3 = insets.left;
                n2 = n4 - insets.left - n6;
                n = n4 - n6;
            } else {
                n = 0;
                n3 = n + n6;
                n2 = n4 - n3 - insets.right;
            }
            int n8 = 0;
            int n9 = n5 / 2 + n5 % 2 - n8;
            int n10 = 0 * insets2.top + n9;
            int n11 = n5 - n10;
            SubstanceSpinnerUI.this.spinner.getEditor().setBounds(n3, insets.top, n2, n7);
            SubstanceSpinnerUI.this.nextButton.setBounds(n, n8, n6, n9);
            SubstanceSpinnerUI.this.prevButton.setBounds(n, n10, n6, n11);
        }
    }
}

