/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.SoftHashMap;

public class LazyResettableHashMap<T> {
    private static List<LazyResettableHashMap<?>> all;
    private Map<HashMapKey, T> cache;
    private String displayName;

    public LazyResettableHashMap(String string) {
        this.displayName = string;
        if (all == null) {
            all = new LinkedList();
        }
        all.add(this);
    }

    private void createIfNecessary() {
        if (this.cache == null) {
            this.cache = new SoftHashMap<HashMapKey, T>();
        }
    }

    public void put(HashMapKey hashMapKey, T t) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Called outside Event Dispatch Thread");
        }
        this.createIfNecessary();
        this.cache.put(hashMapKey, t);
    }

    public T get(HashMapKey hashMapKey) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(hashMapKey);
    }

    public boolean containsKey(HashMapKey hashMapKey) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.containsKey(hashMapKey);
    }

    public int size() {
        if (this.cache == null) {
            return 0;
        }
        return this.cache.size();
    }

    public static void reset() {
        if (all != null) {
            for (LazyResettableHashMap<?> lazyResettableHashMap : all) {
                if (lazyResettableHashMap.cache == null) continue;
                lazyResettableHashMap.cache.clear();
            }
        }
    }

    public static List<String> getStats() {
        if (all != null) {
            String string;
            LinkedList<String> linkedList = new LinkedList<String>();
            TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
            TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
            for (LazyResettableHashMap<?> object : all) {
                string = object.displayName;
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, 0);
                    treeMap2.put(string, 0);
                }
                treeMap.put(string, (Integer)treeMap.get(string) + 1);
                treeMap2.put(string, (Integer)treeMap2.get(string) + object.size());
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                string = (String)entry.getKey();
                linkedList.add(entry.getValue() + " " + string + " with " + treeMap2.get(string) + " entries total");
            }
            return linkedList;
        }
        return null;
    }
}

