/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SchemeBaseColors;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.BaseDarkColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseLightColorScheme;
import org.pushingpixels.substance.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.substance.api.colorscheme.LightGrayColorScheme;
import org.pushingpixels.substance.api.colorscheme.MetallicColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunGlareColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;

public class SubstanceColorSchemeUtilities {
    public static final SubstanceSkin METALLIC_SKIN = SubstanceColorSchemeUtilities.getMetallicSkin();
    public static final SubstanceColorScheme YELLOW = new SunGlareColorScheme();
    public static final SubstanceColorScheme ORANGE = new SunfireRedColorScheme();
    public static final SubstanceColorScheme GREEN = new BottleGreenColorScheme();

    private static SubstanceSkin getMetallicSkin() {
        SubstanceSkin substanceSkin = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return "Metallic Skin";
            }
        };
        substanceSkin.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(new MetallicColorScheme(), new MetallicColorScheme(), new LightGrayColorScheme()), DecorationAreaType.NONE);
        return substanceSkin;
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme substanceColorScheme, boolean bl) {
        Component component2 = component;
        if (component != null && component.getParent() != null && (component instanceof SubstanceInternalArrowButton || component instanceof SubstanceTitleButton)) {
            component2 = component.getParent();
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, substanceColorScheme, component2 == null ? null : component2.getForeground(), component2 == null ? null : component2.getBackground(), bl);
    }

    private static SubstanceColorScheme getColorizedScheme(Component component, SubstanceColorScheme substanceColorScheme, Color color, Color color2, boolean bl) {
        if (component != null) {
            if (color2 instanceof UIResource) {
                color2 = null;
            }
            if (color instanceof UIResource) {
                color = null;
            }
            if (color2 != null || color != null) {
                double d = SubstanceCoreUtilities.getColorizationFactor(component);
                if (!bl) {
                    d /= 2.0;
                }
                if (d > 0.0) {
                    return ShiftColorScheme.getShiftedScheme(substanceColorScheme, color2, d, color, d);
                }
            }
        }
        return substanceColorScheme;
    }

    public static SubstanceColorScheme getColorScheme(JTabbedPane jTabbedPane, int n, ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState componentState) {
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(jTabbedPane);
        if (substanceSkin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(jTabbedPane, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme substanceColorScheme = substanceSkin.getColorScheme(jTabbedPane, colorSchemeAssociationKind, componentState);
        if (n >= 0) {
            Component component = jTabbedPane.getComponentAt(n);
            SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorizedScheme(component, substanceColorScheme, jTabbedPane.getForegroundAt(n), jTabbedPane.getBackgroundAt(n), !componentState.isDisabled());
            return substanceColorScheme2;
        }
        return SubstanceColorSchemeUtilities.getColorizedScheme(jTabbedPane, substanceColorScheme, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        SubstanceSkin substanceSkin;
        boolean bl;
        Component component2 = component;
        boolean bl2 = bl = component instanceof AbstractButton && SubstanceCoreUtilities.isButtonNeverPainted((AbstractButton)component);
        if (bl || SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        if ((substanceSkin = SubstanceCoreUtilities.getSkin(component)) == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(component, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme substanceColorScheme = substanceSkin.getColorScheme(component, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component2, substanceColorScheme, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getColorScheme(Component component, ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme substanceColorScheme = SubstanceCoreUtilities.getSkin(component).getColorScheme(component, colorSchemeAssociationKind, componentState);
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, substanceColorScheme, !componentState.isDisabled());
    }

    public static SubstanceColorScheme getActiveColorScheme(Component component, ComponentState componentState) {
        if (!(component instanceof JToolBar) && SubstanceCoreUtilities.hasFlatAppearance(component, false) && componentState == ComponentState.ENABLED) {
            component = component.getParent();
        }
        SubstanceColorScheme substanceColorScheme = SubstanceCoreUtilities.getSkin(component).getActiveColorScheme(SubstanceLookAndFeel.getDecorationType(component));
        return SubstanceColorSchemeUtilities.getColorizedScheme(component, substanceColorScheme, !componentState.isDisabled());
    }

    public static float getHighlightAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getHighlightAlpha(component, componentState);
    }

    public static float getAlpha(Component component, ComponentState componentState) {
        return SubstanceCoreUtilities.getSkin(component).getAlpha(component, componentState);
    }

    public static SchemeBaseColors getBaseColorScheme(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        Color color5 = null;
        Color color6 = null;
        Color color7 = null;
        try {
            Object object;
            Color[] colorArray;
            while ((colorArray = bufferedReader.readLine()) != null) {
                object = colorArray.split("=");
                if (((String[])object).length != 2) {
                    throw new IllegalArgumentException("Unsupported format in line " + (String)colorArray);
                }
                String string = object[0];
                String string2 = object[1];
                if ("colorUltraLight".equals(string)) {
                    if (color == null) {
                        color = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraLight' should only be defined once");
                }
                if ("colorExtraLight".equals(string)) {
                    if (color2 == null) {
                        color2 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'extraLight' should only be defined once");
                }
                if ("colorLight".equals(string)) {
                    if (color3 == null) {
                        color3 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'light' should only be defined once");
                }
                if ("colorMid".equals(string)) {
                    if (color4 == null) {
                        color4 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'mid' should only be defined once");
                }
                if ("colorDark".equals(string)) {
                    if (color5 == null) {
                        color5 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'dark' should only be defined once");
                }
                if ("colorUltraDark".equals(string)) {
                    if (color6 == null) {
                        color6 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'ultraDark' should only be defined once");
                }
                if ("colorForeground".equals(string)) {
                    if (color7 == null) {
                        color7 = Color.decode(string2);
                        continue;
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + (String)colorArray);
            }
            colorArray = new Color[]{color, color2, color3, color4, color5, color6, color7};
            object = new SchemeBaseColors(){

                @Override
                public String getDisplayName() {
                    return null;
                }

                @Override
                public Color getUltraLightColor() {
                    return colorArray[0];
                }

                @Override
                public Color getExtraLightColor() {
                    return colorArray[1];
                }

                @Override
                public Color getLightColor() {
                    return colorArray[2];
                }

                @Override
                public Color getMidColor() {
                    return colorArray[3];
                }

                @Override
                public Color getDarkColor() {
                    return colorArray[4];
                }

                @Override
                public Color getUltraDarkColor() {
                    return colorArray[5];
                }

                @Override
                public Color getForegroundColor() {
                    return colorArray[6];
                }
            };
            return object;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SubstanceColorScheme getLightColorScheme(String string, final Color[] colorArray) {
        if (colorArray == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colorArray.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseLightColorScheme(string){

            @Override
            public Color getUltraLightColor() {
                return colorArray[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colorArray[1];
            }

            @Override
            public Color getLightColor() {
                return colorArray[2];
            }

            @Override
            public Color getMidColor() {
                return colorArray[3];
            }

            @Override
            public Color getDarkColor() {
                return colorArray[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colorArray[5];
            }

            @Override
            public Color getForegroundColor() {
                return colorArray[6];
            }
        };
    }

    public static SubstanceColorScheme getDarkColorScheme(String string, final Color[] colorArray) {
        if (colorArray == null) {
            throw new IllegalArgumentException("Color encoding cannot be null");
        }
        if (colorArray.length != 7) {
            throw new IllegalArgumentException("Color encoding must have 7 components");
        }
        return new BaseDarkColorScheme(string){

            @Override
            public Color getUltraLightColor() {
                return colorArray[0];
            }

            @Override
            public Color getExtraLightColor() {
                return colorArray[1];
            }

            @Override
            public Color getLightColor() {
                return colorArray[2];
            }

            @Override
            public Color getMidColor() {
                return colorArray[3];
            }

            @Override
            public Color getDarkColor() {
                return colorArray[4];
            }

            @Override
            public Color getUltraDarkColor() {
                return colorArray[5];
            }

            @Override
            public Color getForegroundColor() {
                return colorArray[6];
            }
        };
    }

    public static SubstanceSkin.ColorSchemes getColorSchemes(URL uRL) {
        ArrayList<SubstanceColorScheme> arrayList;
        block36: {
            arrayList = new ArrayList<SubstanceColorScheme>();
            BufferedReader bufferedReader = null;
            Color color = null;
            Color color2 = null;
            Color color3 = null;
            Color color4 = null;
            Color color5 = null;
            Color color6 = null;
            Color color7 = null;
            String string = null;
            ColorSchemeKind colorSchemeKind = null;
            boolean bl = false;
            try {
                String string2;
                block37: {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while (true) {
                        Object[] objectArray;
                        if ((string2 = bufferedReader.readLine()) == null) {
                            break block36;
                        }
                        if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
                        if (string2.indexOf("{") >= 0) {
                            if (bl) {
                                throw new IllegalArgumentException("Already in color scheme definition");
                            }
                            bl = true;
                            string = string2.substring(0, string2.indexOf("{")).trim();
                            continue;
                        }
                        if (string2.indexOf("}") >= 0) {
                            if (!bl) {
                                throw new IllegalArgumentException("Not in color scheme definition");
                            }
                            bl = false;
                            if (string == null || colorSchemeKind == null || color == null || color2 == null || color3 == null || color4 == null || color5 == null || color6 == null || color7 == null) {
                                throw new IllegalArgumentException("Incomplete specification");
                            }
                            objectArray = new Color[]{color, color2, color3, color4, color5, color6, color7};
                            if (colorSchemeKind == ColorSchemeKind.LIGHT) {
                                arrayList.add(SubstanceColorSchemeUtilities.getLightColorScheme(string, (Color[])objectArray));
                            } else {
                                arrayList.add(SubstanceColorSchemeUtilities.getDarkColorScheme(string, (Color[])objectArray));
                            }
                            string = null;
                            colorSchemeKind = null;
                            color = null;
                            color2 = null;
                            color3 = null;
                            color4 = null;
                            color5 = null;
                            color6 = null;
                            color7 = null;
                            continue;
                        }
                        objectArray = string2.split("=");
                        if (objectArray.length != 2) {
                            throw new IllegalArgumentException("Unsupported format in line " + string2);
                        }
                        String string3 = objectArray[0].trim();
                        String string4 = objectArray[1].trim();
                        if ("kind".equals(string3)) {
                            if (colorSchemeKind == null) {
                                if ("Light".equals(string4)) {
                                    colorSchemeKind = ColorSchemeKind.LIGHT;
                                    continue;
                                }
                                if ("Dark".equals(string4)) {
                                    colorSchemeKind = ColorSchemeKind.DARK;
                                    continue;
                                }
                                throw new IllegalArgumentException("Unsupported format in line " + string2);
                            }
                            throw new IllegalArgumentException("'kind' should only be defined once");
                        }
                        if ("colorUltraLight".equals(string3)) {
                            if (color == null) {
                                color = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraLight' should only be defined once");
                        }
                        if ("colorExtraLight".equals(string3)) {
                            if (color2 == null) {
                                color2 = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'extraLight' should only be defined once");
                        }
                        if ("colorLight".equals(string3)) {
                            if (color3 == null) {
                                color3 = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'light' should only be defined once");
                        }
                        if ("colorMid".equals(string3)) {
                            if (color4 == null) {
                                color4 = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'mid' should only be defined once");
                        }
                        if ("colorDark".equals(string3)) {
                            if (color5 == null) {
                                color5 = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'dark' should only be defined once");
                        }
                        if ("colorUltraDark".equals(string3)) {
                            if (color6 == null) {
                                color6 = Color.decode(string4);
                                continue;
                            }
                            throw new IllegalArgumentException("'ultraDark' should only be defined once");
                        }
                        if (!"colorForeground".equals(string3)) break block37;
                        if (color7 != null) break;
                        color7 = Color.decode(string4);
                    }
                    throw new IllegalArgumentException("'foreground' should only be defined once");
                }
                throw new IllegalArgumentException("Unsupported format in line " + string2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return new SubstanceSkin.ColorSchemes(arrayList);
    }

    private static enum ColorSchemeKind {
        LIGHT,
        DARK;

    }
}

