/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.lafwidget.utils.TrackableThread;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetManager;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceTitlePane
extends JComponent {
    private PropertyChangeListener propertyChangeListener;
    protected JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    protected JButton toggleButton;
    protected JButton minimizeButton;
    protected JButton closeButton;
    private WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    private int state;
    private SubstanceRootPaneUI rootPaneUI;
    private static String heapStatusLogfileName;
    protected HeapStatusPanel heapStatusPanel;
    protected JCheckBoxMenuItem heapStatusMenuItem;
    protected PropertyChangeListener propertyListener;
    protected static final String EXTRA_COMPONENT_KIND = "substancelaf.internal.titlePane.extraComponentKind";
    protected Image appIcon;

    public SubstanceTitlePane(JRootPane jRootPane, SubstanceRootPaneUI substanceRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = substanceRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
        SubstanceLookAndFeel.setDecorationType(this, DecorationAreaType.PRIMARY_TITLE_PANE);
        this.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        HeapStatusThread.unregisterPanel(this.heapStatusPanel);
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
        }
        if (this.heapStatusPanel != null) {
            for (MouseListener mouseListener : this.heapStatusPanel.getMouseListeners()) {
                this.heapStatusPanel.removeMouseListener(mouseListener);
            }
            HeapStatusThread.unregisterPanel(this.heapStatusPanel);
            this.remove(this.heapStatusPanel);
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if ("windowModified".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceTitlePane.this.syncCloseButtonTooltip();
                }
                if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceTitlePane.this.menuBar != null) {
                                SubstanceTitlePane.this.menuBar.applyComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                            }
                        }
                    });
                }
            }
        };
        this.rootPane.addPropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().addPropertyChangeListener(this.propertyListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.rootPane.removePropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = null;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.getComponentCount() == 0) {
                this.installSubcomponents();
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
        this.updateAppIcon();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    private void installSubcomponents() {
        int n = this.getWindowDecorationStyle();
        if (n == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            if (this.menuBar != null) {
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.heapStatusPanel = new HeapStatusPanel();
            this.markExtraComponent(this.heapStatusPanel, ExtraComponentKind.TRAILING);
            this.add(this.heapStatusPanel);
            boolean bl = SubstanceWidgetManager.getInstance().isAllowed(this.rootPane, SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS);
            this.heapStatusPanel.setVisible(bl);
            this.heapStatusPanel.setPreferredSize(new Dimension(80, this.getPreferredSize().height));
            this.heapStatusPanel.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.heapStatusPanel"));
            this.heapStatusPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    System.gc();
                }
            });
            HeapStatusThread.registerPanel(this.heapStatusPanel);
        } else if (n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        this.markExtraComponent(this.menuBar, ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        jMenu.setOpaque(false);
        jMenu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(jMenu);
        }
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu) {
        jMenu.add(this.restoreAction);
        jMenu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenu.add(this.maximizeAction);
        }
        if (SubstanceCoreUtilities.toShowExtraWidgets(this.rootPane)) {
            jMenu.addSeparator();
            JMenu jMenu2 = new JMenu(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.skins"));
            Map<String, SkinInfo> map = SubstanceLookAndFeel.getAllSkins();
            for (Map.Entry<String, SkinInfo> entry : map.entrySet()) {
                final String string = entry.getValue().getClassName();
                JMenuItem jMenuItem = new JMenuItem(entry.getKey());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SubstanceLookAndFeel.setSkin(string);
                            }
                        });
                    }
                });
                jMenu2.add(jMenuItem);
            }
            jMenu.add(jMenu2);
        }
        jMenu.addSeparator();
        jMenu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        SubstanceTitleButton substanceTitleButton = new SubstanceTitleButton();
        substanceTitleButton.setFocusPainted(false);
        substanceTitleButton.setFocusable(false);
        substanceTitleButton.setOpaque(true);
        this.markExtraComponent(substanceTitleButton, ExtraComponentKind.TRAILING);
        return substanceTitleButton;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setBorder(null);
        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.closeButton, new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE));
            }
        }, "substance.titlePane.closeIcon");
        this.closeButton.setIcon(transitionAwareIcon);
        this.closeButton.setFocusable(false);
        this.closeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.setBorder(null);
            TransitionAwareIcon transitionAwareIcon2 = new TransitionAwareIcon(this.minimizeButton, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE));
                }
            }, "substance.titlePane.minIcon");
            this.minimizeButton.setIcon(transitionAwareIcon2);
            this.minimizeButton.setFocusable(false);
            this.minimizeButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            this.minimizeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.iconify"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.setBorder(null);
            this.toggleButton.setText(null);
            TransitionAwareIcon transitionAwareIcon3 = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                @Override
                public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                    return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, substanceColorScheme, SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE));
                }
            }, "substance.titlePane.maxIcon");
            this.toggleButton.setIcon(transitionAwareIcon3);
            this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.maximize"));
            this.toggleButton.setFocusable(false);
            this.toggleButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        }
        this.syncCloseButtonTooltip();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl) {
        this.getRootPane().repaint();
    }

    private void setState(int n) {
        this.setState(n, false);
    }

    private void setState(int n, boolean bl) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                final JRootPane jRootPane = this.getRootPane();
                if ((n & 6) != 0 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    jRootPane.setBorder(null);
                } else if ((n & 6) == 0) {
                    this.rootPaneUI.installBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n & 6) != 0) {
                        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            @Override
                            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, substanceColorScheme, SubstanceCoreUtilities.getSkin(jRootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE));
                            }
                        }, "substance.titlePane.restoreIcon");
                        this.updateToggleButton(this.restoreAction, transitionAwareIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(jRootPane).getString("SystemMenu.restore"));
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        TransitionAwareIcon transitionAwareIcon = new TransitionAwareIcon(this.toggleButton, new TransitionAwareIcon.Delegate(){

                            @Override
                            public Icon getColorSchemeIcon(SubstanceColorScheme substanceColorScheme) {
                                return SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, substanceColorScheme, SubstanceCoreUtilities.getSkin(jRootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE));
                            }
                        }, "substance.titlePane.maxIcon");
                        this.updateToggleButton(this.maximizeAction, transitionAwareIcon);
                        this.toggleButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(jRootPane).getString("SystemMenu.maximize"));
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        Object object;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane jRootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl = window == null ? jRootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int n = this.getWidth();
        int n2 = this.getHeight();
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(jRootPane);
        if (substanceSkin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(this, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme substanceColorScheme = substanceSkin.getEnabledColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
        int n3 = 0;
        String string = this.getTitle();
        if (string != null) {
            int n4;
            object = this.getTitleTextRectangle();
            serializable = jRootPane.getFontMetrics(graphics.getFont());
            String string2 = SubstanceCoreUtilities.clipString((FontMetrics)serializable, n4 = ((Rectangle)object).width - 20, string);
            if (string.equals(string2)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(string);
            }
            string = string2;
            n3 = bl ? ((Rectangle)object).x : ((Rectangle)object).x + ((Rectangle)object).width - ((FontMetrics)serializable).stringWidth(string);
        }
        object = (Graphics2D)graphics.create();
        serializable = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
        ((Graphics)object).setFont((Font)serializable);
        BackgroundPaintingUtils.update((Graphics)object, this, false);
        if (string != null) {
            FontMetrics fontMetrics = jRootPane.getFontMetrics(((Graphics)object).getFont());
            int n5 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            SubstanceTextUtilities.paintTextWithDropShadow(this, (Graphics)object, SubstanceColorUtilities.getForegroundColor(substanceColorScheme), string, n, n2, n3, n5);
        }
        GhostPaintingUtils.paintGhostImages(this, (Graphics)object);
        ((Graphics)object).dispose();
    }

    protected Rectangle getTitleTextRectangle() {
        int n;
        boolean bl;
        JRootPane jRootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl2 = bl = window == null ? jRootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        if (bl) {
            int n2;
            int n3 = 0;
            int n4 = this.getWidth();
            for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
                int n5;
                Component component = this.getComponent(n2);
                if (!component.isVisible() || !(component instanceof JComponent)) continue;
                ExtraComponentKind extraComponentKind = (ExtraComponentKind)((Object)((JComponent)component).getClientProperty(EXTRA_COMPONENT_KIND));
                if (extraComponentKind == null) {
                    throw new IllegalStateException("Title pane child " + component.getClass().getName() + " is not marked as leading or trailing");
                }
                if (extraComponentKind == ExtraComponentKind.LEADING) {
                    n5 = component.getX() + component.getWidth();
                    if (n5 <= n3) continue;
                    n3 = n5;
                    continue;
                }
                n5 = component.getX();
                if (n5 >= n4) continue;
                n4 = n5;
            }
            n2 = n3 + 10;
            int n6 = n4 - 5;
            return new Rectangle(n2, 0, n6 - n2, this.getHeight());
        }
        int n7 = this.getWidth();
        int n8 = 0;
        for (n = 0; n < this.getComponentCount(); ++n) {
            int n9;
            Component component = this.getComponent(n);
            if (!component.isVisible() || !(component instanceof JComponent)) continue;
            ExtraComponentKind extraComponentKind = (ExtraComponentKind)((Object)((JComponent)component).getClientProperty(EXTRA_COMPONENT_KIND));
            if (extraComponentKind == null) {
                throw new IllegalStateException("Title pane child " + component.getClass().getName() + " is not marked as leading or trailing");
            }
            if (extraComponentKind == ExtraComponentKind.LEADING) {
                n9 = component.getX();
                if (n9 >= n7) continue;
                n7 = n9;
                continue;
            }
            n9 = component.getX() + component.getWidth();
            if (n9 <= n8) continue;
            n8 = n9;
        }
        n = n8 + 5;
        int n10 = n7 - 10;
        return new Rectangle(n, 0, n10 - n, this.getHeight());
    }

    public static void setHeapStatusLogfileName(String string) {
        heapStatusLogfileName = string;
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isRootPaneModified(this.getRootPane())) {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close") + " [" + SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCoreUtilities.getResourceBundle(this.rootPane).getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    protected void markExtraComponent(JComponent jComponent, ExtraComponentKind extraComponentKind) {
        jComponent.putClientProperty(EXTRA_COMPONENT_KIND, (Object)extraComponentKind);
    }

    private void updateAppIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.appIcon = null;
            return;
        }
        List<Image> list = window.getIconImages();
        if (list.size() == 0) {
            this.appIcon = null;
        } else {
            int n = SubstanceSizeUtils.getTitlePaneIconSize();
            this.appIcon = SubstanceCoreUtilities.getScaledIconImage(list, n, n);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            SubstanceTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            SubstanceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = SubstanceTitlePane.this.getFrame();
                if (frame != null) {
                    SubstanceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    SubstanceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                SubstanceTitlePane.this.repaint();
                SubstanceTitlePane.this.setToolTipText((String)propertyChangeEvent.getNewValue());
            } else if ("componentOrientation" == string) {
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            } else if ("iconImage" == string) {
                SubstanceTitlePane.this.updateAppIcon();
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        private int computeHeight() {
            FontMetrics fontMetrics = SubstanceTitlePane.this.rootPane.getFontMetrics(SubstanceTitlePane.this.getFont());
            int n = fontMetrics.getHeight();
            n += 7;
            int n2 = 0;
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                n2 = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            int n3 = Math.max(n, n2);
            return n3;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            boolean bl = SubstanceTitlePane.this.window == null ? SubstanceTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : SubstanceTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n3 = SubstanceTitlePane.this.getWidth();
            int n4 = 3;
            if (SubstanceTitlePane.this.closeButton != null && SubstanceTitlePane.this.closeButton.getIcon() != null) {
                n2 = SubstanceTitlePane.this.closeButton.getIcon().getIconHeight();
                n = SubstanceTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                n2 = SubstanceSizeUtils.getTitlePaneIconSize();
                n = SubstanceSizeUtils.getTitlePaneIconSize();
            }
            n4 = (SubstanceTitlePane.this.getHeight() - n2) / 2;
            int n5 = bl ? n3 : 0;
            int n6 = 5;
            int n7 = n5 = bl ? n6 : n3 - n - n6;
            if (SubstanceTitlePane.this.menuBar != null) {
                SubstanceTitlePane.this.menuBar.setBounds(n5, n4, n, n2);
            }
            n5 = bl ? n3 : 0;
            n6 = 3;
            n5 += bl ? -n6 - n : n6;
            if (SubstanceTitlePane.this.closeButton != null) {
                SubstanceTitlePane.this.closeButton.setBounds(n5, n4, n, n2);
            }
            if (!bl) {
                n5 += n;
            }
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && SubstanceTitlePane.this.toggleButton.getParent() != null) {
                    n6 = 10;
                    SubstanceTitlePane.this.toggleButton.setBounds(n5 += bl ? -n6 - n : n6, n4, n, n2);
                    if (!bl) {
                        n5 += n;
                    }
                }
                if (SubstanceTitlePane.this.minimizeButton != null && SubstanceTitlePane.this.minimizeButton.getParent() != null) {
                    n6 = 2;
                    SubstanceTitlePane.this.minimizeButton.setBounds(n5 += bl ? -n6 - n : n6, n4, n, n2);
                    if (!bl) {
                        n5 += n;
                    }
                }
                if (SubstanceTitlePane.this.heapStatusPanel != null && SubstanceTitlePane.this.heapStatusPanel.isVisible()) {
                    n6 = 5;
                    SubstanceTitlePane.this.heapStatusPanel.setBounds(n5 += bl ? -n6 - SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth() : n6, 1, SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth(), SubstanceTitlePane.this.getHeight() - 3);
                }
            }
        }
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics graphics) {
            if (SubstanceTitlePane.this.appIcon != null) {
                graphics.drawImage(SubstanceTitlePane.this.appIcon, 0, 0, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(n, dimension.width), Math.max(dimension.height, n));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.maximize"), SubstanceImageCreator.getMaximizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getEnabledColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                if (frame instanceof JFrame) {
                    SubstanceRootPaneUI substanceRootPaneUI = (SubstanceRootPaneUI)((JFrame)frame).getRootPane().getUI();
                    substanceRootPaneUI.setMaximized();
                }
                frame.setExtendedState(SubstanceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.restore"), SubstanceImageCreator.getRestoreIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((SubstanceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.iconify"), SubstanceImageCreator.getMinimizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(SubstanceCoreUtilities.getResourceBundle(SubstanceTitlePane.this.rootPane).getString("SystemMenu.close"), SubstanceImageCreator.getCloseIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Window window = SubstanceTitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }

    public static class HeapStatusThread
    extends TrackableThread {
        private int heapSizeKB;
        private int takenHeapSizeKB;
        private static Set<WeakReference<HeapStatusPanel>> panels = new HashSet<WeakReference<HeapStatusPanel>>();
        private static HeapStatusThread instance;
        private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
        private boolean isStopRequested = false;

        private HeapStatusThread() {
            this.setName("Substance heap status");
        }

        public static synchronized HeapStatusThread getInstance() {
            if (instance == null) {
                instance = new HeapStatusThread();
                instance.start();
            }
            return instance;
        }

        public static synchronized void registerPanel(HeapStatusPanel heapStatusPanel) {
            panels.add(new WeakReference<HeapStatusPanel>(heapStatusPanel));
        }

        public static synchronized void unregisterPanel(HeapStatusPanel heapStatusPanel) {
            Iterator<WeakReference<HeapStatusPanel>> iterator = panels.iterator();
            while (iterator.hasNext()) {
                WeakReference<HeapStatusPanel> weakReference = iterator.next();
                HeapStatusPanel heapStatusPanel2 = (HeapStatusPanel)weakReference.get();
                if (heapStatusPanel != heapStatusPanel2) continue;
                iterator.remove();
                return;
            }
        }

        private synchronized void updateHeapCounts() {
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().freeMemory();
            this.heapSizeKB = (int)(l / 1024L);
            this.takenHeapSizeKB = (int)((l - l2) / 1024L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isStopRequested) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!SubstanceWidgetManager.getInstance().isAllowedAnywhere(SubstanceConstants.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS)) continue;
                this.updateHeapCounts();
                Object object = panels.iterator();
                while (object.hasNext()) {
                    WeakReference<HeapStatusPanel> weakReference = object.next();
                    HeapStatusPanel heapStatusPanel = (HeapStatusPanel)weakReference.get();
                    if (heapStatusPanel == null) {
                        object.remove();
                        continue;
                    }
                    heapStatusPanel.updateStatus(this.heapSizeKB, this.takenHeapSizeKB);
                }
                if (heapStatusLogfileName == null) continue;
                object = null;
                try {
                    object = new PrintWriter(new FileWriter(heapStatusLogfileName, true));
                    ((PrintWriter)object).println(this.format.format(new Date()) + " " + this.takenHeapSizeKB + "KB / " + this.heapSizeKB + "KB");
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (object == null) continue;
                    ((PrintWriter)object).close();
                }
            }
        }

        @Override
        protected void requestStop() {
            this.isStopRequested = true;
            instance = null;
        }
    }

    public static class HeapStatusPanel
    extends JPanel {
        private int currHeapSizeKB;
        private int currTakenHeapSizeKB;
        private LinkedList<Double> graphValues = new LinkedList();

        public HeapStatusPanel() {
            HeapStatusThread.getInstance();
        }

        public synchronized void updateStatus(int n, int n2) {
            this.currHeapSizeKB = n;
            this.currTakenHeapSizeKB = n2;
            double d = (double)n2 / (double)n;
            this.graphValues.addLast(d);
            this.repaint();
        }

        @Override
        public synchronized void paint(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            SubstanceColorScheme substanceColorScheme = SubstanceCoreUtilities.getSkin(this).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE);
            graphics2D.setColor(substanceColorScheme.getDarkColor());
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            graphics2D.drawRect(0, 0, n2 - 1, n3 - 1);
            graphics2D.setColor(substanceColorScheme.getExtraLightColor());
            graphics2D.fillRect(1, 1, n2 - 2, n3 - 2);
            while (this.graphValues.size() > n2 - 2) {
                this.graphValues.removeFirst();
            }
            int n4 = n2 - this.graphValues.size() - 1;
            graphics2D.setColor(substanceColorScheme.getMidColor());
            int n5 = 0;
            Object object = this.graphValues.iterator();
            while (object.hasNext()) {
                double d = (Double)object.next();
                n = (int)(d * (double)(n3 - 2));
                graphics2D.drawLine(n4 + n5, n3 - 1 - n, n4 + n5, n3 - 2);
                ++n5;
            }
            graphics2D.setFont(UIManager.getFont("Panel.font"));
            object = graphics2D.getFontMetrics();
            StringBuffer stringBuffer = new StringBuffer();
            Formatter formatter = new Formatter(stringBuffer);
            formatter.format("%.1fMB / %.1fMB", Float.valueOf((float)this.currTakenHeapSizeKB / 1024.0f), Float.valueOf((float)this.currHeapSizeKB / 1024.0f));
            n = ((FontMetrics)object).stringWidth(stringBuffer.toString());
            int n6 = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getDescent();
            graphics2D.setColor(substanceColorScheme.getForegroundColor());
            RenderingUtils.installDesktopHints(graphics2D, this);
            if (n < n2 - 5) {
                graphics2D.drawString(stringBuffer.toString(), (n2 - n) / 2, (n3 + n6) / 2 - 2);
            } else {
                String string = this.currTakenHeapSizeKB / 1024 + "MB / " + this.currHeapSizeKB / 1024 + "MB";
                n = ((FontMetrics)object).stringWidth(string);
                graphics2D.drawString(string, (n2 - n) / 2, (n3 + n6) / 2 - 2);
            }
            graphics2D.dispose();
        }

        public int getPreferredWidth() {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            RenderingUtils.installDesktopHints(graphics2D, this);
            graphics2D.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth("100.9MB / 200.9MB");
            graphics2D.dispose();
            return n;
        }
    }

    protected static enum ExtraComponentKind {
        LEADING,
        TRAILING;

    }
}

