/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class UpdateOptimizationInfo {
    private JComponent component;
    public boolean toDrawWatermark;
    private Map<ComponentState, SubstanceColorScheme> highlightSchemeMap;
    private Map<ComponentState, SubstanceColorScheme> highlightBorderSchemeMap;
    private Map<ComponentState, SubstanceColorScheme> borderSchemeMap;
    private Map<ComponentState, SubstanceColorScheme> fillSchemeMap;
    private Map<ComponentState, Float> highlightAlphaMap;
    private SubstanceColorScheme defaultScheme;
    public DecorationAreaType decorationAreaType;
    public boolean isInDecorationArea;

    public UpdateOptimizationInfo(JComponent jComponent) {
        this.component = jComponent;
        this.toDrawWatermark = SubstanceCoreUtilities.toDrawWatermark(this.component);
        this.defaultScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, ComponentState.ENABLED);
        this.decorationAreaType = SubstanceLookAndFeel.getDecorationType(this.component);
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(this.component);
        this.isInDecorationArea = this.decorationAreaType != null && substanceSkin.isRegisteredAsDecorationArea(this.decorationAreaType) && SubstanceCoreUtilities.isOpaque(this.component);
    }

    public SubstanceColorScheme getHighlightColorScheme(ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme;
        if (this.highlightSchemeMap == null) {
            this.highlightSchemeMap = new HashMap<ComponentState, SubstanceColorScheme>();
        }
        if ((substanceColorScheme = this.highlightSchemeMap.get(componentState)) == null) {
            substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
            this.highlightSchemeMap.put(componentState, substanceColorScheme);
        }
        return substanceColorScheme;
    }

    public SubstanceColorScheme getBorderColorScheme(ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme;
        if (this.borderSchemeMap == null) {
            this.borderSchemeMap = new HashMap<ComponentState, SubstanceColorScheme>();
        }
        if ((substanceColorScheme = this.borderSchemeMap.get(componentState)) == null) {
            substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, ColorSchemeAssociationKind.BORDER, componentState);
            this.borderSchemeMap.put(componentState, substanceColorScheme);
        }
        return substanceColorScheme;
    }

    public SubstanceColorScheme getFillColorScheme(ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme;
        if (componentState == ComponentState.ENABLED) {
            return this.defaultScheme;
        }
        if (this.fillSchemeMap == null) {
            this.fillSchemeMap = new HashMap<ComponentState, SubstanceColorScheme>();
        }
        if ((substanceColorScheme = this.fillSchemeMap.get(componentState)) == null) {
            substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, componentState);
            this.fillSchemeMap.put(componentState, substanceColorScheme);
        }
        return substanceColorScheme;
    }

    public SubstanceColorScheme getHighlightBorderColorScheme(ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme;
        if (this.highlightBorderSchemeMap == null) {
            this.highlightBorderSchemeMap = new HashMap<ComponentState, SubstanceColorScheme>();
        }
        if ((substanceColorScheme = this.highlightBorderSchemeMap.get(componentState)) == null) {
            substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.component, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, componentState);
            this.highlightBorderSchemeMap.put(componentState, substanceColorScheme);
        }
        return substanceColorScheme;
    }

    public float getHighlightAlpha(ComponentState componentState) {
        if (this.highlightAlphaMap == null) {
            this.highlightAlphaMap = new HashMap<ComponentState, Float>();
        }
        if (!this.highlightAlphaMap.containsKey(componentState)) {
            this.highlightAlphaMap.put(componentState, Float.valueOf(SubstanceColorSchemeUtilities.getHighlightAlpha(this.component, componentState)));
        }
        return this.highlightAlphaMap.get(componentState).floatValue();
    }

    public SubstanceColorScheme getDefaultScheme() {
        return this.defaultScheme;
    }
}

