/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.filters;

import java.awt.image.BufferedImage;
import org.pushingpixels.substance.internal.utils.filters.AbstractFilter;

public class TranslucentFilter
extends AbstractFilter {
    private double alpha;

    public TranslucentFilter(double d) {
        this.alpha = d;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        this.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        this.translucentColor(nArray);
        this.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    private void translucentColor(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = (int)(this.alpha * (double)(n >>> 24 & 0xFF));
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n >>> 0 & 0xFF;
            nArray[i] = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        }
    }
}

