import xchat, re, string

__module_name__ = "Rainbow"
__module_version__ = "2.0.0"
__module_description__ = "Generates rainbow colored versions of the text you enter. Post it for the specified line-count"

def Rainbow(text,offset):
	colorlist = [4,7,8,9,11,12,13,6]
	rainbowed = ""

	for i in range(len(text)):
		rainbowed += "\x03{}{}".format(colorlist[(i+offset)%len(colorlist)], text[i])
	return rainbowed
def rainbowcmd(word,word_eol,userdata):
	try:
		count = int(word[-1])
		text = ' '.join(word[1:-1])
	except ValueError:
		count = 1
		text = ' '.join(word[1:])
	for i in range(0,count):
		(xchat.get_context()).command("say {}".format(Rainbow(text,i)))

xchat.hook_command("r",rainbowcmd,help="/r (text) (line count)")
print("Rainbow script by DEElekgolo loaded. use /r (text) (count) to generate rainbow-ed text")
