/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupListUsersRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupListUsersDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupListUsersDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupListUsersRequest) {
            GroupListUsersRequest req = (GroupListUsersRequest)request;
            LOG.debug((Object)("List users in group " + request));
            GetGroupRequest getGroupRequest = new GetGroupRequest();
            getGroupRequest.setGroupName(req.getGroupName());
            getGroupRequest.setMarker(req.getMarker());
            getGroupRequest.setMaxItems(req.getMaxItems());
            GetGroupResult result = this.getClient().getGroup(getGroupRequest);
            for (User user : result.getUsers()) {
                LOG.info((Object)user.getArn());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

