/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.VirtualMFADeviceListRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListVirtualMFADevicesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListVirtualMFADevicesResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.VirtualMFADevice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMVirtualMFADeviceListDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMVirtualMFADeviceListDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof VirtualMFADeviceListRequest) {
            VirtualMFADeviceListRequest req = (VirtualMFADeviceListRequest)request;
            ListVirtualMFADevicesRequest listMFADevicesRequest = new ListVirtualMFADevicesRequest();
            listMFADevicesRequest.setAssignmentStatus(req.getAssignmentStatus());
            listMFADevicesRequest.setMarker(req.getMarker());
            listMFADevicesRequest.setMaxItems(req.getMaxItems());
            LOG.debug((Object)("Calling listmfadevice with request " + request));
            ListVirtualMFADevicesResult res = this.getClient().listVirtualMFADevices(listMFADevicesRequest);
            for (VirtualMFADevice device : res.getVirtualMFADevices()) {
                LOG.info((Object)device.getSerialNumber());
                if (!req.isVerbose() || device.getUser() == null) continue;
                LOG.info((Object)device.getUser().getArn());
                LOG.info((Object)device.getUser().getUserId());
            }
            LOG.info((Object)("IsTruncated: " + res.getIsTruncated()));
            if (res.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + res.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

