/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class BottomLineOverlayPainter
implements SubstanceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public BottomLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeSingleColorQuery) {
        this.colorSchemeQuery = colorSchemeSingleColorQuery;
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        int n3 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n3);
        graphics2D.setStroke(new BasicStroke(f));
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        graphics2D.setColor(this.colorSchemeQuery.query(substanceColorScheme));
        graphics2D.drawLine(0, component2.getHeight() - (int)f, n, component2.getHeight() - (int)f);
    }

    @Override
    public String getDisplayName() {
        return "Bottom Line";
    }
}

