/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class TopBezelOverlayPainter
implements SubstanceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQueryTop;
    ColorSchemeSingleColorQuery colorSchemeQueryBottom;

    public TopBezelOverlayPainter(ColorSchemeSingleColorQuery colorSchemeSingleColorQuery, ColorSchemeSingleColorQuery colorSchemeSingleColorQuery2) {
        this.colorSchemeQueryTop = colorSchemeSingleColorQuery;
        this.colorSchemeQueryBottom = colorSchemeSingleColorQuery2;
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        Point point = SwingUtilities.convertPoint(component, new Point(0, 0), component2);
        int n3 = point.y;
        int n4 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n4);
        graphics2D.setStroke(new BasicStroke(f));
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        graphics2D.setColor(this.colorSchemeQueryTop.query(substanceColorScheme));
        graphics2D.drawLine(0, (int)f - n3 - 1, n, (int)f - n3 - 1);
        graphics2D.setColor(this.colorSchemeQueryBottom.query(substanceColorScheme));
        graphics2D.drawLine(0, (int)(2.0f * f) - n3 - 1, n, (int)(2.0f * f) - n3 - 1);
    }

    @Override
    public String getDisplayName() {
        return "Top Line Shadow";
    }
}

