/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

@SubstanceRenderer
public class SubstanceDefaultTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    public SubstanceDefaultTableHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        SubstanceColorScheme substanceColorScheme;
        Object object2;
        Object object3;
        Object object4;
        ComponentUI componentUI;
        if (jTable == null) {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            this.setValue(object);
            this.setOpaque(false);
            return this;
        }
        if (jTable.getTableHeader() == null) {
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableHeaderUI tableHeaderUI = jTableHeader.getUI();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && tableHeaderUI instanceof SubstanceTableHeaderUI) {
            componentUI = (SubstanceTableHeaderUI)tableHeaderUI;
            object4 = componentUI.getModelStateInfo(n2);
            object3 = componentUI.getColumnState(n2);
            if (object4 != null) {
                object2 = ((StateTransitionTracker.ModelStateInfo)object4).getStateContributionMap();
                substanceColorScheme = this.getColorSchemeForState(jTableHeader, (ComponentState)object3);
                if (((ComponentState)object3).isDisabled() || object2 == null || object2.size() == 1) {
                    super.setForeground(new ColorUIResource(substanceColorScheme.getForegroundColor()));
                } else {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : ((StateTransitionTracker.ModelStateInfo)object4).getStateContributionMap().entrySet()) {
                        ComponentState componentState = entry.getKey();
                        SubstanceColorScheme substanceColorScheme2 = this.getColorSchemeForState(jTableHeader, componentState);
                        Color color = substanceColorScheme2.getForegroundColor();
                        float f4 = entry.getValue().getContribution();
                        f += (float)color.getRed() * f4;
                        f2 += (float)color.getGreen() * f4;
                        f3 += (float)color.getBlue() * f4;
                    }
                    super.setForeground(new ColorUIResource(new Color((int)f, (int)f2, (int)f3)));
                }
            } else {
                object2 = this.getColorSchemeForState(jTableHeader, (ComponentState)object3);
                super.setForeground(new ColorUIResource(object2.getForegroundColor()));
            }
        } else {
            super.setForeground(jTable.getForeground());
        }
        this.setBackground(jTableHeader.getBackground());
        if (jTableHeader.getFont() != null) {
            this.setFont(jTableHeader.getFont());
        } else {
            this.setFont(jTable.getFont());
        }
        componentUI = jTable.getUI();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && componentUI instanceof SubstanceTableUI) {
            this.setBorder(new EmptyBorder(((SubstanceTableUI)componentUI).getCellRendererInsets()));
        }
        this.setValue(object);
        this.setOpaque(false);
        this.setEnabled(jTableHeader.isEnabled() && jTable.isEnabled());
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            this.setIcon(null);
            object4 = jTable.getRowSorter();
            if (object4 != null) {
                this.setHorizontalTextPosition(10);
                object3 = ((RowSorter)object4).getSortKeys();
                object2 = null;
                substanceColorScheme = null;
                if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
                    SubstanceTableHeaderUI substanceTableHeaderUI = (SubstanceTableHeaderUI)tableHeaderUI;
                    ComponentState componentState = substanceTableHeaderUI.getColumnState(n2);
                    ColorSchemeAssociationKind colorSchemeAssociationKind = componentState == ComponentState.ENABLED ? ColorSchemeAssociationKind.MARK : ColorSchemeAssociationKind.HIGHLIGHT_MARK;
                    substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTableHeader, colorSchemeAssociationKind, componentState);
                } else {
                    substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jTableHeader, ComponentState.ENABLED);
                }
                if (object3.size() > 0 && ((RowSorter.SortKey)object3.get(0)).getColumn() == jTable.convertColumnIndexToModel(n2)) {
                    switch (((RowSorter.SortKey)object3.get(0)).getSortOrder()) {
                        case ASCENDING: {
                            object2 = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(jTableHeader), 1, substanceColorScheme);
                            break;
                        }
                        case DESCENDING: {
                            object2 = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(jTableHeader), 5, substanceColorScheme);
                            break;
                        }
                        case UNSORTED: {
                            object2 = null;
                        }
                    }
                    this.setIcon((Icon)object2);
                }
            }
        }
        return this;
    }

    private SubstanceColorScheme getColorSchemeForState(JTableHeader jTableHeader, ComponentState componentState) {
        SubstanceColorScheme substanceColorScheme = componentState == ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(jTableHeader, componentState) : SubstanceColorSchemeUtilities.getColorScheme(jTableHeader, ColorSchemeAssociationKind.HIGHLIGHT, componentState);
        return substanceColorScheme;
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }
}

