/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.watermark.SubstanceCrosshatchWatermark;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class MarinerSkin
extends SubstanceSkin {
    public static final String NAME = "Mariner";
    private BottomLineOverlayPainter menuOverlayPainter;
    private TopLineOverlayPainter toolbarOverlayPainter;
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public MarinerSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/mariner.colorschemes");
        SubstanceColorScheme substanceColorScheme = colorSchemes.get("Mariner Active");
        SubstanceColorScheme substanceColorScheme2 = colorSchemes.get("Mariner Enabled");
        SubstanceColorScheme substanceColorScheme3 = colorSchemes.get("Mariner Disabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme2, substanceColorScheme3);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme3, 0.8f, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme4 = colorSchemes.get("Mariner Active Border");
        SubstanceColorScheme substanceColorScheme5 = colorSchemes.get("Mariner Enabled Border");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme5, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme substanceColorScheme6 = colorSchemes.get("Mariner Active Mark");
        SubstanceColorScheme substanceColorScheme7 = colorSchemes.get("Mariner Enabled Mark");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme6, ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme7, ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        ComponentState componentState = new ComponentState("uneditable", new ComponentStateFacet[]{ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.EDITABLE});
        SubstanceColorScheme substanceColorScheme8 = colorSchemes.get("Mariner Uneditable");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme8, ColorSchemeAssociationKind.FILL, componentState);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, DecorationAreaType.NONE);
        SubstanceColorScheme substanceColorScheme9 = colorSchemes.get("Mariner Header");
        SubstanceColorScheme substanceColorScheme10 = colorSchemes.get("Mariner Header Border");
        SubstanceColorSchemeBundle substanceColorSchemeBundle2 = new SubstanceColorSchemeBundle(substanceColorScheme9, substanceColorScheme9, substanceColorScheme9);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme9, 0.5f, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme9, ComponentState.ROLLOVER_UNSELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme9, ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme10, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle2, substanceColorScheme9, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER);
        SubstanceColorScheme substanceColorScheme11 = colorSchemes.get("Mariner Footer Enabled");
        SubstanceColorScheme substanceColorScheme12 = colorSchemes.get("Mariner Footer Disabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle3 = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme11, substanceColorScheme12);
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme12, 0.8f, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme13 = colorSchemes.get("Mariner Footer Enabled Border");
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme13, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme substanceColorScheme14 = colorSchemes.get("Mariner Footer Enabled Mark");
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme6, ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme14, ColorSchemeAssociationKind.MARK, ComponentState.ENABLED);
        SubstanceColorScheme substanceColorScheme15 = colorSchemes.get("Mariner Footer Separator");
        substanceColorSchemeBundle3.registerColorScheme(substanceColorScheme15, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme substanceColorScheme16 = colorSchemes.get("Mariner Footer Watermark");
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle3, substanceColorScheme16, DecorationAreaType.FOOTER, DecorationAreaType.TOOLBAR, DecorationAreaType.GENERAL);
        this.setSelectedTabFadeStart(0.15);
        this.setSelectedTabFadeEnd(0.25);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.LIGHT);
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, DecorationAreaType.FOOTER);
        this.menuOverlayPainter = new BottomLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                return substanceColorScheme.getUltraDarkColor().darker();
            }
        });
        this.toolbarOverlayPainter = new TopLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                Color color = substanceColorScheme.getForegroundColor();
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), 32);
            }
        });
        this.addOverlayPainter(this.menuOverlayPainter, DecorationAreaType.HEADER);
        this.addOverlayPainter(this.toolbarOverlayPainter, DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(ColorSchemeSingleColorQuery.ULTRADARK);
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new TextureWatermark();
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new FractionBasedBorderPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.MID});
        this.highlightBorderPainter = new ClassicBorderPainter();
        this.watermarkScheme = colorSchemes.get("Mariner Watermark");
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    private static class TextureWatermark
    implements SubstanceWatermark {
        private static Image watermarkImage = null;

        private TextureWatermark() {
        }

        @Override
        public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
            if (!component.isShowing()) {
                return;
            }
            int n5 = component.getLocationOnScreen().x;
            int n6 = component.getLocationOnScreen().y;
            graphics.drawImage(watermarkImage, n, n2, n + n3, n2 + n4, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, null);
        }

        @Override
        public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
            GraphicsDevice[] graphicsDeviceArray;
            Rectangle rectangle = new Rectangle();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                rectangle = rectangle.union(graphicsConfiguration.getBounds());
            }
            int n = rectangle.width;
            int n2 = rectangle.height;
            watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            Graphics2D graphics2D = (Graphics2D)watermarkImage.getGraphics().create();
            boolean bl = this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false);
            graphics2D.dispose();
            return bl;
        }

        @Override
        public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
            this.drawWatermarkImage(substanceSkin, (Graphics2D)graphics, n, n2, n3, n4, true);
        }

        private boolean drawWatermarkImage(SubstanceSkin substanceSkin, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
            Color color = null;
            Color color2 = null;
            Color color3 = null;
            SubstanceColorScheme substanceColorScheme = substanceSkin.getWatermarkColorScheme();
            if (bl) {
                color = substanceColorScheme.isDark() ? Color.white : Color.black;
                color2 = Color.lightGray;
                color3 = substanceColorScheme.isDark() ? Color.black : Color.white;
            } else {
                color = substanceColorScheme.getWatermarkDarkColor();
                color2 = substanceColorScheme.getWatermarkStampColor();
                color3 = substanceColorScheme.getWatermarkLightColor();
            }
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n3, n4);
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(8, 4);
            int n5 = color.getRGB();
            bufferedImage.setRGB(0, 0, n5);
            bufferedImage.setRGB(0, 1, n5);
            bufferedImage.setRGB(0, 2, n5);
            bufferedImage.setRGB(0, 3, n5);
            bufferedImage.setRGB(1, 2, n5);
            bufferedImage.setRGB(2, 1, n5);
            bufferedImage.setRGB(3, 0, n5);
            bufferedImage.setRGB(4, 0, n5);
            bufferedImage.setRGB(4, 1, n5);
            bufferedImage.setRGB(4, 2, n5);
            bufferedImage.setRGB(4, 3, n5);
            bufferedImage.setRGB(5, 0, n5);
            bufferedImage.setRGB(6, 1, n5);
            bufferedImage.setRGB(7, 2, n5);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.05f));
            for (int i = n2; i < n2 + n4; i += 4) {
                for (int j = n; j < n + n3; j += 8) {
                    graphics2D2.drawImage((Image)bufferedImage, j, i, null);
                }
            }
            graphics2D2.dispose();
            return true;
        }

        @Override
        public String getDisplayName() {
            return SubstanceCrosshatchWatermark.getName();
        }

        public static String getName() {
            return "Crosshatch";
        }

        @Override
        public void dispose() {
            watermarkImage = null;
        }
    }
}

