/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.VolatileImage;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.painter.border.FlatBorderPainter;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.painter.SimplisticFillPainter;
import org.pushingpixels.substance.internal.utils.PairwiseButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSplitPaneDivider;
import org.pushingpixels.substance.internal.utils.filters.ColorSchemeFilter;
import org.pushingpixels.substance.internal.utils.filters.GrayscaleFilter;
import org.pushingpixels.substance.internal.utils.filters.NegatedFilter;
import org.pushingpixels.substance.internal.utils.filters.TranslucentFilter;

public final class SubstanceImageCreator {
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    public static void paintBorder(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, float f, SubstanceColorScheme substanceColorScheme) {
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(component);
        graphics2D.translate(n, n2);
        int n5 = SubstanceSizeUtils.getComponentFontSize(component);
        int n6 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(n5) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n3, n4, f, null, n6);
        int n7 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n5);
        boolean bl = component instanceof JTextComponent || SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null && SwingUtilities.getAncestorOfClass(JFileChooser.class, component) != null;
        GeneralPath generalPath2 = bl ? null : SubstanceOutlineUtilities.getBaseOutline(n3, n4, f - (float)n7, null, n7 + n6);
        substanceBorderPainter.paintBorder(graphics2D, component, n3, n4, generalPath, generalPath2, substanceColorScheme);
        graphics2D.translate(-n, -n2);
    }

    public static void paintTextComponentBorder(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, float f, SubstanceColorScheme substanceColorScheme) {
        int n5 = SubstanceSizeUtils.getComponentFontSize(jComponent);
        int n6 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(n5) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n3, n4, f, SubstanceCoreUtilities.getSides(jComponent, "substancelaf.buttonside"), n6);
        int n7 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n5);
        GeneralPath generalPath2 = SubstanceOutlineUtilities.getBaseOutline(n3, n4, f - (float)n7, null, n7 + n6);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        ComponentState componentState = jComponent.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Color color = SubstanceColorUtilities.getDefaultBackgroundColor(jComponent, componentState);
        if (componentState.isDisabled()) {
            float f2 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState);
            color = SubstanceColorUtilities.getAlphaColor(color, (int)(255.0f * f2));
        }
        Color color2 = SubstanceColorUtilities.getOuterTextComponentBorderColor(color);
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        double d = 0.85;
        double d2 = 0.8;
        if (fArray[2] < 0.3f) {
            d = 0.6;
            d2 = 0.95;
        } else if (fArray[2] < 0.5f) {
            d = 0.8;
        } else if (fArray[2] < 0.75f) {
            d = 0.7;
        }
        Color color3 = substanceColorScheme.getDarkColor();
        Color color4 = SubstanceColorUtilities.getInterpolatedColor(color3, color, d2);
        Color color5 = SubstanceColorUtilities.getInterpolatedColor(color, color3, d);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        float f3 = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jComponent));
        graphics2D.setStroke(new BasicStroke(f3, 0, 1));
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n4, color2));
        graphics2D.draw(generalPath);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color4, 0.0f, n4, color5));
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
    }

    private static BufferedImage getCheckMark(int n, boolean bl, SubstanceColorScheme substanceColorScheme, float f) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.25f * (float)n, 0.5f * (float)n);
        generalPath.quadTo(0.37f * (float)n, 0.6f * (float)n, 0.47f * (float)n, 0.8f * (float)n);
        generalPath.quadTo(0.55f * (float)n, 0.5f * (float)n, 0.85f * (float)n, 0.0f);
        float f2 = 0.15f * (float)n;
        float f3 = 0.95f * (float)n;
        float f4 = f2 + (f3 - f2) * f;
        graphics2D.setClip(0, 0, (int)Math.ceil(f4), n);
        graphics2D.setColor(SubstanceColorUtilities.getMarkColor(substanceColorScheme, bl));
        BasicStroke basicStroke = new BasicStroke(0.15f * (float)n, 1, 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(generalPath);
        return bufferedImage;
    }

    public static Icon getArrowIcon(int n, int n2, SubstanceColorScheme substanceColorScheme) {
        float f = SubstanceSizeUtils.getArrowIconWidth(n);
        float f2 = SubstanceSizeUtils.getArrowIconHeight(n);
        if (n2 == 0) {
            f2 *= 2.0f;
        }
        float f3 = SubstanceSizeUtils.getArrowStrokeWidth(n);
        return new ImageIcon(SubstanceImageCreator.getArrow(f, f2, f3, n2, substanceColorScheme));
    }

    public static Icon getArrowIcon(float f, float f2, float f3, int n, SubstanceColorScheme substanceColorScheme) {
        return new ImageIcon(SubstanceImageCreator.getArrow(f, f2, f3, n, substanceColorScheme));
    }

    public static BufferedImage getArrow(float f, float f2, float f3, int n, SubstanceColorScheme substanceColorScheme) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage((int)f, (int)f2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(1, 1);
        f2 -= 2.0f;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        int n2 = (f -= 2.0f) < 15.0f ? 0 : 1;
        BasicStroke basicStroke = new BasicStroke(f3, n2, 0);
        graphics2D.setStroke(basicStroke);
        int n3 = (int)f3 / 2;
        if (n == 0) {
            BufferedImage bufferedImage2 = SubstanceImageCreator.getArrow(f, f2 / 2.0f, f3, 1, substanceColorScheme);
            BufferedImage bufferedImage3 = SubstanceImageCreator.getArrow(f, f2 / 2.0f, f3, 5, substanceColorScheme);
            graphics2D.drawImage((Image)bufferedImage2, 0, 1, null);
            graphics2D.drawImage((Image)bufferedImage3, 0, (int)f2 / 2 - 1, null);
            return bufferedImage;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n3, f3);
        generalPath.lineTo(0.5f * (f - 1.0f), f2 - 1.0f - (float)n3);
        generalPath.lineTo(f - 1.0f - (float)n3, f3);
        graphics2D.draw(generalPath);
        int n4 = 0;
        switch (n) {
            case 1: {
                n4 = 2;
                break;
            }
            case 7: {
                n4 = 1;
                break;
            }
            case 5: {
                n4 = 0;
                break;
            }
            case 3: {
                n4 = 3;
            }
        }
        BufferedImage bufferedImage4 = SubstanceImageCreator.getRotated(bufferedImage, n4);
        return bufferedImage4;
    }

    public static Icon getDoubleArrowIconDelta(int n, float f, float f2, float f3, int n2, SubstanceColorScheme substanceColorScheme) {
        float f4 = SubstanceSizeUtils.getArrowIconWidth(n) + f;
        float f5 = SubstanceSizeUtils.getArrowIconHeight(n) + f2;
        float f6 = SubstanceSizeUtils.getDoubleArrowStrokeWidth(n) + f3;
        return SubstanceImageCreator.getDoubleArrowIcon(n, f4, f5, f6, n2, substanceColorScheme);
    }

    public static Icon getDoubleArrowIcon(int n, float f, float f2, float f3, int n2, SubstanceColorScheme substanceColorScheme) {
        boolean bl;
        int n3 = 3 + 2 * SubstanceSizeUtils.getExtraPadding(n) / 3;
        boolean bl2 = bl = n2 == 7 || n2 == 3;
        if (bl) {
            float f4 = f;
            f = f2;
            f2 = f4;
        }
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage((int)f, (int)f2);
        BufferedImage bufferedImage2 = SubstanceImageCreator.getArrow(f, Math.max(1.0f, f2 - (float)n3), f3, 5, substanceColorScheme);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = bufferedImage2.getHeight();
        int n5 = bufferedImage2.getWidth();
        int n6 = bl ? (int)(f2 - (float)n4 - (float)n3) / 2 : (int)(f - (float)n5 - (float)n3) / 2;
        graphics2D.drawImage((Image)bufferedImage2, 0, n6, null);
        graphics2D.drawImage((Image)bufferedImage2, 0, n6 + n3, null);
        int n7 = 0;
        switch (n2) {
            case 1: {
                n7 = 2;
                break;
            }
            case 7: {
                n7 = 1;
                break;
            }
            case 5: {
                n7 = 0;
                break;
            }
            case 3: {
                n7 = 3;
            }
        }
        BufferedImage bufferedImage3 = SubstanceImageCreator.getRotated(bufferedImage, n7);
        return new ImageIcon(bufferedImage3);
    }

    public static BufferedImage getRotated(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if ((n %= 4) == 1 || n == 3) {
            n2 = bufferedImage.getHeight();
            n3 = bufferedImage.getWidth();
        }
        BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n2, n3);
        AffineTransform affineTransform = null;
        switch (n) {
            case 1: {
                affineTransform = AffineTransform.getTranslateInstance(n2, 0.0);
                affineTransform.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                affineTransform = AffineTransform.getTranslateInstance(n2, n3);
                affineTransform.rotate(Math.PI);
                break;
            }
            case 3: {
                affineTransform = AffineTransform.getTranslateInstance(0.0, n3);
                affineTransform.rotate(-1.5707963267948966);
            }
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static VolatileImage getRotated(VolatileImage volatileImage, int n) {
        int n2 = volatileImage.getWidth();
        int n3 = volatileImage.getHeight();
        if ((n %= 4) == 1 || n == 3) {
            n2 = volatileImage.getHeight();
            n3 = volatileImage.getWidth();
        }
        VolatileImage volatileImage2 = SubstanceCoreUtilities.getBlankVolatileImage(n2, n3);
        AffineTransform affineTransform = null;
        switch (n) {
            case 1: {
                affineTransform = AffineTransform.getTranslateInstance(n2, 0.0);
                affineTransform.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                affineTransform = AffineTransform.getTranslateInstance(n2, n3);
                affineTransform.rotate(Math.PI);
                break;
            }
            case 3: {
                affineTransform = AffineTransform.getTranslateInstance(0.0, n3);
                affineTransform.rotate(-1.5707963267948966);
            }
        }
        Graphics2D graphics2D = volatileImage2.createGraphics();
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.drawImage(volatileImage, 0, 0, null);
        graphics2D.dispose();
        return volatileImage2;
    }

    public static Icon toGreyscale(Icon icon) {
        if (icon == null) {
            return null;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(new GrayscaleFilter().filter(bufferedImage, null));
    }

    public static Icon makeTransparent(Component component, Icon icon, double d) {
        if (icon == null) {
            return null;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(new TranslucentFilter(d).filter(bufferedImage, null));
    }

    public static BufferedImage getRadioButton(JComponent jComponent, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, ComponentState componentState, int n2, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, SubstanceColorScheme substanceColorScheme3, float f) {
        if (!componentState.isActive()) {
            substanceFillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        float f2 = SubstanceSizeUtils.getBorderStrokeWidth(n);
        int n3 = (int)((double)f2 - 0.6);
        Ellipse2D.Float float_ = new Ellipse2D.Float(n3, n3, n - 2 * n3 - 1, n - 2 * n3 - 1);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n + n2, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        float f3 = SubstanceColorSchemeUtilities.getAlpha(jComponent, componentState);
        graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
        graphics2D.translate(n2, 0);
        substanceFillPainter.paintContourBackground(graphics2D, jComponent, n, n, float_, false, substanceColorScheme, true);
        Ellipse2D.Float float_2 = new Ellipse2D.Float((float)n3 + f2, (float)n3 + f2, (float)(n - 2 * n3) - 2.0f * f2, (float)(n - 2 * n3) - 2.0f * f2);
        substanceBorderPainter.paintBorder(graphics2D, jComponent, n, n, float_, float_2, substanceColorScheme3);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        float f4 = (float)n / 2.0f;
        float f5 = (float)n / 4.5f;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if ((double)f > 0.0) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(f4 - f5, f4 - f5, 2.0f * f5, 2.0f * f5);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * f));
            SubstanceImageCreator.drawRadioMark(graphics2D, SubstanceColorUtilities.getMarkColor(substanceColorScheme2, !componentState.isDisabled()), double_);
        } else {
            graphics2D.setPaint(new GradientPaint(f4 + f5, f4 - f5, substanceColorScheme.getDarkColor(), f4 - f5, f4 + f5, substanceColorScheme.getLightColor()));
            Ellipse2D.Double double_ = new Ellipse2D.Double(f4 - f5, f4 - f5, 2.0f * f5, 2.0f * f5);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * 0.3f));
            graphics2D.fill(double_);
        }
        graphics2D.translate(-n2, 0);
        return bufferedImage;
    }

    private static void drawRadioMark(Graphics2D graphics2D, Color color, Shape shape) {
        graphics2D.setColor(color);
        graphics2D.fill(shape);
    }

    public static BufferedImage getCheckBox(AbstractButton abstractButton, SubstanceFillPainter substanceFillPainter, SubstanceBorderPainter substanceBorderPainter, int n, ComponentState componentState, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, SubstanceColorScheme substanceColorScheme3, float f, boolean bl) {
        int n2;
        int n3 = n2 = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(abstractButton), 3, 9, 1, false);
        float f2 = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(abstractButton));
        if (n <= 10) {
            n2 = 2;
            f2 = 2.0f;
        }
        int n4 = n - n3;
        int n5 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n4, n4, f2, null, n5);
        if (!componentState.isActive()) {
            substanceFillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        float f3 = SubstanceColorSchemeUtilities.getAlpha(abstractButton, componentState);
        graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
        graphics2D.translate(n3 - 1, n3 - 1);
        substanceFillPainter.paintContourBackground(graphics2D, abstractButton, n4, n4, generalPath, false, substanceColorScheme, true);
        int n6 = (int)SubstanceSizeUtils.getBorderStrokeWidth(n);
        GeneralPath generalPath2 = SubstanceOutlineUtilities.getBaseOutline(n4, n4, f2 - (float)n6, null, n6 + n5);
        substanceBorderPainter.paintBorder(graphics2D, abstractButton, n4, n4, generalPath, generalPath2, substanceColorScheme3);
        graphics2D.translate(-n3, 1 - n3);
        if ((double)f > 0.0) {
            if (bl) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3 * f));
                f = 1.0f;
            }
            BufferedImage bufferedImage2 = SubstanceImageCreator.getCheckMark(n - 2 * n2 / 3, !componentState.isDisabled(), substanceColorScheme2, f);
            graphics2D.drawImage((Image)bufferedImage2, 1 + 2 * n2 / 3, n < 14 ? 0 : -1, null);
        }
        return bufferedImage;
    }

    public static void paintCompositeRoundedBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, AbstractButton abstractButton, AbstractButton abstractButton2, boolean bl) {
        Graphics2D graphics2D;
        int n4 = 3;
        if (abstractButton != null) {
            graphics2D = (Graphics2D)graphics.create();
            if (!bl) {
                graphics2D.clip(new Rectangle(-n4, 0, n / 2, n2));
                graphics2D.translate(-n4, 0);
            } else {
                graphics2D.clip(new Rectangle(n / 2, 0, n / 2 + 1, n2));
            }
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(graphics2D, abstractButton, n + 2 * n4, n2, bl ? SubstanceConstants.Side.RIGHT : SubstanceConstants.Side.LEFT, true);
            graphics2D.dispose();
        }
        if (abstractButton2 != null) {
            graphics2D = (Graphics2D)graphics.create();
            if (!bl) {
                graphics2D.clip(new Rectangle(n / 2, 0, n / 2 + 1, n2));
            } else {
                graphics2D.clip(new Rectangle(-n4, 0, n / 2, n2));
                graphics2D.translate(-n4, 0);
            }
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(graphics2D, abstractButton2, n + 2 * n4, n2, bl ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT, true);
            graphics2D.dispose();
        }
    }

    private static BufferedImage overlayEcho(BufferedImage bufferedImage, float f, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        n2 = 0;
        n = 0;
        BufferedImage bufferedImage2 = SubstanceImageCreator.getNegated(bufferedImage);
        BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n3, n4);
        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics().create();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f * f * f * f));
        graphics2D.drawImage((Image)bufferedImage2, n - 1, n2 - 1, null);
        graphics2D.drawImage((Image)bufferedImage2, n + 1, n2 - 1, null);
        graphics2D.drawImage((Image)bufferedImage2, n - 1, n2 + 1, null);
        graphics2D.drawImage((Image)bufferedImage2, n + 1, n2 + 1, null);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f * f * f * f));
        graphics2D.drawImage((Image)bufferedImage2, n, n2 - 1, null);
        graphics2D.drawImage((Image)bufferedImage2, n, n2 + 1, null);
        graphics2D.drawImage((Image)bufferedImage2, n - 1, n2, null);
        graphics2D.drawImage((Image)bufferedImage2, n + 1, n2, null);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static Icon getMinimizeIcon(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        int n = SubstanceSizeUtils.getTitlePaneIconSize();
        return SubstanceImageCreator.getMinimizeIcon(n, substanceColorScheme, substanceColorScheme2);
    }

    public static Icon getMinimizeIcon(int n, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n2 = n / 4 - 2;
        int n3 = 3 * n / 4;
        int n4 = n3 - n2 - 3;
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        graphics2D.fillRect(n2 + 2, n3 - 2, n4, 3);
        int n5 = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int n6 = SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()));
        int n7 = SubstanceColorUtilities.getColorBrightness(substanceColorScheme2.getLightColor().getRGB());
        boolean bl = n5 > n6 && n5 < n7;
        return new ImageIcon(SubstanceImageCreator.overlayEcho(bufferedImage, bl ? 0.0f : SubstanceColorUtilities.getColorStrength(color), 1, 1));
    }

    public static Icon getRestoreIcon(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        int n = SubstanceSizeUtils.getTitlePaneIconSize();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n2 = n / 4 - 2;
        int n3 = 3 * n / 4 - 1;
        int n4 = n3 - n2 - 3;
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        graphics2D.drawRect(n2, n3 - n4 + 1, n4, n4);
        graphics2D.drawLine(n2, n3 - n4 + 2, n2 + n4, n3 - n4 + 2);
        graphics2D.fillRect(n3 - n4, n2 + 1, n4 + 1, 2);
        graphics2D.drawLine(n3, n2 + 1, n3, n2 + n4 + 1);
        graphics2D.drawLine(n2 + n4 + 2, n2 + n4 + 1, n3, n2 + n4 + 1);
        int n5 = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int n6 = SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()));
        int n7 = SubstanceColorUtilities.getColorBrightness(substanceColorScheme2.getLightColor().getRGB());
        boolean bl = n5 > n6 && n5 < n7;
        return new ImageIcon(SubstanceImageCreator.overlayEcho(bufferedImage, bl ? 0.0f : SubstanceColorUtilities.getColorStrength(color), 1, 1));
    }

    public static Icon getMaximizeIcon(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        int n = SubstanceSizeUtils.getTitlePaneIconSize();
        return SubstanceImageCreator.getMaximizeIcon(n, substanceColorScheme, substanceColorScheme2);
    }

    public static Icon getMaximizeIcon(int n, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n2 = n / 4 - 1;
        int n3 = n - n2 - 1;
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        graphics2D.drawRect(n2, n2, n3 - n2, n3 - n2);
        graphics2D.drawLine(n2, n2 + 1, n3, n2 + 1);
        int n4 = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int n5 = SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()));
        int n6 = SubstanceColorUtilities.getColorBrightness(substanceColorScheme2.getLightColor().getRGB());
        boolean bl = n4 > n5 && n4 < n6;
        return new ImageIcon(SubstanceImageCreator.overlayEcho(bufferedImage, bl ? 0.0f : SubstanceColorUtilities.getColorStrength(color), 1, 1));
    }

    public static Icon getCloseIcon(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        return SubstanceImageCreator.getCloseIcon(SubstanceSizeUtils.getTitlePaneIconSize(), substanceColorScheme, substanceColorScheme2);
    }

    public static Icon getCloseIcon(int n, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (n < 15) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        int n2 = n / 4;
        int n3 = 3 * n / 4;
        BasicStroke basicStroke = new BasicStroke(SubstanceSizeUtils.getFocusStrokeWidth(n), 1, 1);
        graphics2D.setStroke(basicStroke);
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        graphics2D.drawLine(n2, n2, n3, n3);
        graphics2D.drawLine(n2, n3, n3, n2);
        int n4 = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int n5 = SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()));
        int n6 = SubstanceColorUtilities.getColorBrightness(substanceColorScheme2.getLightColor().getRGB());
        boolean bl = n4 > n5 && n4 < n6;
        return new ImageIcon(SubstanceImageCreator.overlayEcho(bufferedImage, bl ? 0.0f : SubstanceColorUtilities.getColorStrength(color), 1, 1));
    }

    public static void paintRectangularBackground(Component component, Graphics graphics, int n, int n2, int n3, int n4, SubstanceColorScheme substanceColorScheme, float f, boolean bl) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        if (!bl) {
            object = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n4, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{substanceColorScheme.getUltraLightColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor(), substanceColorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(0, 0, n3, n4);
        } else {
            object = new LinearGradientPaint(0.0f, 0.0f, n3, 0.0f, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{substanceColorScheme.getUltraLightColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor(), substanceColorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(0, 0, n3, n4);
        }
        if (f > 0.0f) {
            object = (Graphics2D)graphics2D.create();
            ((Graphics2D)object).setComposite(LafWidgetUtilities.getAlphaComposite(null, f, graphics2D));
            SubstanceImageCreator.paintSimpleBorderAliased(component, (Graphics2D)object, n3, n4, substanceColorScheme);
            ((Graphics)object).dispose();
        }
        graphics2D.dispose();
    }

    public static void paintSimpleBorder(Component component, Graphics2D graphics2D, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        int n3 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = (float)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n3));
        graphics2D.setColor(SubstanceColorUtilities.getMidBorderColor(substanceColorScheme));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n4 = 1;
        int n5 = 0;
        graphics2D.setStroke(new BasicStroke(f, n5, n4));
        graphics2D.draw(new Rectangle2D.Float((f - 1.0f) / 2.0f, (f - 1.0f) / 2.0f, (float)(n - 1) - (f - 1.5f), (float)(n2 - 1) - (f - 1.5f)));
    }

    public static void paintSimpleBorderAliased(Component component, Graphics2D graphics2D, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        int n3 = SubstanceSizeUtils.getComponentFontSize(component);
        float f = (float)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n3));
        graphics2D.setColor(SubstanceColorUtilities.getMidBorderColor(substanceColorScheme));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n4 = 0;
        int n5 = 2;
        graphics2D.setStroke(new BasicStroke(f, n5, n4));
        graphics2D.draw(new Rectangle2D.Float(f / 2.0f, f / 2.0f, (float)n - f, (float)n2 - f));
    }

    public static void paintRectangularStripedBackground(Component component, Graphics graphics, int n, int n2, int n3, int n4, SubstanceColorScheme substanceColorScheme, BufferedImage bufferedImage, int n5, float f, boolean bl) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create(n, n2, n3, n4);
        if (!bl) {
            object = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n4, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{substanceColorScheme.getDarkColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(0, 0, n3, n4);
            if (bufferedImage != null) {
                int n6 = bufferedImage.getHeight();
                int n7 = n3 / n6;
                n5 %= 2 * n6;
                for (int i = -2; i <= n7; i += 2) {
                    int n8 = i * n6 + n5;
                    graphics2D.drawImage((Image)bufferedImage, n8, 0, null);
                }
            }
        } else {
            object = new LinearGradientPaint(0.0f, 0.0f, n3, 0.0f, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{substanceColorScheme.getDarkColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getMidColor(), substanceColorScheme.getLightColor(), substanceColorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(0, 0, n3, n4);
            if (bufferedImage != null) {
                int n9 = bufferedImage.getWidth();
                int n10 = n4 / n9;
                n5 %= 2 * n9;
                for (int i = -2; i <= n10; i += 2) {
                    int n11 = i * n9 + n5;
                    graphics2D.drawImage((Image)bufferedImage, 0, n11, null);
                }
            }
        }
        if (f > 0.0f) {
            object = (Graphics2D)graphics2D.create();
            ((Graphics2D)object).setComposite(LafWidgetUtilities.getAlphaComposite(null, f, graphics2D));
            SubstanceImageCreator.paintSimpleBorderAliased(component, (Graphics2D)object, n3, n4, substanceColorScheme);
            ((Graphics)object).dispose();
        }
        graphics2D.dispose();
    }

    public static BufferedImage getStripe(int n, Color color) {
        int n2 = (int)(1.8 * (double)n);
        int n3 = n;
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n2, n3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(n2 - 1 - n, 0);
        polygon.addPoint(n2 - 1, n3 - 1);
        polygon.addPoint(n, n3 - 1);
        graphics2D.setColor(color);
        graphics2D.fillPolygon(polygon);
        graphics2D.drawPolygon(polygon);
        float[] fArray = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.3f, 0.1f, 0.1f, 0.1f, 0.1f};
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray));
        BufferedImage bufferedImage2 = convolveOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static BufferedImage getDragImage(Component component, SubstanceColorScheme substanceColorScheme, int n, int n2, int n3) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = substanceColorScheme.isDark();
        Color color = bl ? substanceColorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getLightColor(), substanceColorScheme.getDarkColor(), 0.8);
        Color color2 = bl ? substanceColorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getDarkColor(), 0.4);
        Color color3 = bl ? substanceColorScheme.getDarkColor() : substanceColorScheme.getUltraLightColor();
        int n4 = SubstanceSizeUtils.getComponentFontSize(component);
        int n5 = SubstanceSizeUtils.getDragBumpDiameter(n4);
        int n6 = (int)(1.5 * (double)n5 + 1.0);
        int n7 = Math.max(1, n2 / n6 - 1);
        int n8 = Math.max(1, (n - 2) / n6);
        if (n3 > 0) {
            if (n2 > n) {
                n8 = Math.min(n8, n3);
            } else {
                n7 = Math.min(n7, n3);
            }
        }
        int n9 = (n2 - n6 * n7) / 2;
        int n10 = 1 + (n - n6 * n8) / 2;
        for (int i = 0; i < n8; ++i) {
            int n11 = n10 + i * n6;
            boolean bl2 = i % 2 == 0;
            int n12 = bl2 ? 0 : n5;
            for (int j = 0; j < n7; ++j) {
                int n13 = n12 + n9 + j * n6;
                graphics2D.setColor(color3);
                graphics2D.fillOval(n11 + 1, n13 + 1, n5, n5);
                graphics2D.setPaint(new GradientPaint(n11, n13, color, n11 + n5 - 1, n13 + n5 - 1, color2));
                graphics2D.fillOval(n11, n13, n5, n5);
            }
        }
        return bufferedImage;
    }

    public static void paintSplitDividerBumpImage(Graphics graphics, SubstanceSplitPaneDivider substanceSplitPaneDivider, int n, int n2, int n3, int n4, boolean bl, SubstanceColorScheme substanceColorScheme) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = SubstanceSizeUtils.getComponentFontSize(substanceSplitPaneDivider);
        int n6 = SubstanceSizeUtils.getBigDragBumpDiameter(n5);
        int n7 = (int)(1.5 * (double)n6 + 1.0);
        int n8 = bl ? 1 : Math.max(1, n4 / n7 - 1);
        int n9 = bl ? Math.max(1, (n3 - 2) / n7) : 1;
        int n10 = (n4 - n7 * n8) / 2;
        int n11 = 1 + (n3 - n7 * n9) / 2;
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n6, n6);
        Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, substanceSplitPaneDivider.isEnabled());
        graphics2D2.setColor(color);
        graphics2D2.fillOval(0, 0, n6, n6);
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(substanceSplitPaneDivider);
        substanceBorderPainter.paintBorder(graphics2D2, substanceSplitPaneDivider, n3, n4, new Ellipse2D.Float(0.0f, 0.0f, n6 - 1, n6 - 1), null, substanceColorScheme);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(substanceSplitPaneDivider, 0.8f, graphics));
        for (int i = 0; i < n9; ++i) {
            int n12 = n11 + i * n7;
            for (int j = 0; j < n8; ++j) {
                int n13 = n10 + j * n7 + (n7 - n6) / 2;
                graphics2D.drawImage((Image)bufferedImage, n12, n13, null);
            }
        }
        graphics2D.dispose();
    }

    public static BufferedImage getResizeGripImage(Component component, SubstanceColorScheme substanceColorScheme, int n, boolean bl) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl2 = substanceColorScheme.isDark();
        Color color = bl2 ? substanceColorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getLightColor(), substanceColorScheme.getDarkColor(), 0.8);
        Color color2 = bl2 ? substanceColorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getDarkColor(), 0.4);
        Color color3 = bl2 ? substanceColorScheme.getDarkColor() : substanceColorScheme.getUltraLightColor();
        int n2 = SubstanceSizeUtils.getDragBumpDiameter(SubstanceSizeUtils.getComponentFontSize(component));
        int n3 = (int)(1.5 * (double)n2 + 1.0);
        if (bl) {
            --n3;
        }
        int n4 = n / n3;
        int n5 = (n - n3 * n4) / 2;
        for (int i = 0; i < n4; ++i) {
            int n6 = n5 + i * n3;
            for (int j = n4 - i - 1; j < n4; ++j) {
                int n7 = n5 + j * n3;
                graphics2D.setColor(color3);
                graphics2D.fillOval(n6 + 1, n7 + 1, n2, n2);
                graphics2D.setPaint(new GradientPaint(n6, n7, color, n6 + n2 - 1, n7 + n2 - 1, color2));
                graphics2D.fillOval(n6, n7, n2, n2);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage getTreeIcon(JTree jTree, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, boolean bl) {
        Color color;
        int n = SubstanceSizeUtils.getComponentFontSize(jTree);
        int n2 = SubstanceSizeUtils.getTreeIconSize(n);
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n2 + 2, n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        SimplisticSoftBorderReverseFillPainter simplisticSoftBorderReverseFillPainter = new SimplisticSoftBorderReverseFillPainter();
        FlatBorderPainter flatBorderPainter = new FlatBorderPainter();
        int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(n) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n2 - 1, n2 - 1, SubstanceSizeUtils.getClassicButtonCornerRadius(n2), null, n3);
        graphics2D2.translate(0, 1);
        boolean bl2 = substanceColorScheme.isDark();
        substanceColorScheme = new ShiftColorScheme(substanceColorScheme, substanceColorScheme.getExtraLightColor(), 0.7);
        simplisticSoftBorderReverseFillPainter.paintContourBackground(graphics2D2, jTree, n2 - 1, n2 - 1, generalPath, false, substanceColorScheme, false);
        substanceColorScheme2 = new ShiftColorScheme(substanceColorScheme2, bl2 ? substanceColorScheme2.getUltraLightColor() : substanceColorScheme2.getLightColor(), 0.5);
        flatBorderPainter.paintBorder(graphics2D2, jTree, n2 - 1, n2 - 1, generalPath, null, substanceColorScheme2);
        graphics2D2.translate(-1, -1);
        Color color2 = color = bl2 ? substanceColorScheme2.getUltraLightColor().brighter().brighter() : substanceColorScheme2.getUltraDarkColor();
        if (jTree != null && !jTree.isEnabled()) {
            color = substanceColorScheme2.getForegroundColor();
        }
        graphics2D2.setColor(color);
        int n4 = n2 / 2;
        int n5 = 5 * n2 / 12;
        graphics2D2.drawLine(n4 - n5 / 2, n2 / 2, n4 + n5 / 2, n2 / 2);
        if (bl) {
            graphics2D2.drawLine(n2 / 2, n4 - n5 / 2, n2 / 2, n4 + n5 / 2);
        }
        graphics2D2.dispose();
        return bufferedImage;
    }

    public static BufferedImage getSingleCrayon(Color color, int n, int n2) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        int n3 = (int)(0.2 * (double)n2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        double d = 0.8;
        int n7 = (int)((double)n4 + (double)(255 - n4) * d);
        int n8 = (int)((double)n5 + (double)(255 - n5) * d);
        int n9 = (int)((double)n6 + (double)(255 - n6) * d);
        double d2 = 0.05;
        int n10 = (int)((1.0 - d2) * (double)n4);
        int n11 = (int)((1.0 - d2) * (double)n5);
        int n12 = (int)((1.0 - d2) * (double)n6);
        Color color2 = new Color(n7, n8, n9);
        Color color3 = new Color(n10, n11, n12);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{color2, color3, color3, color2, color2}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(0, n3, n, n2);
        int n13 = n7;
        int n14 = n8;
        int n15 = n9;
        int n16 = 128 + n10 / 4;
        int n17 = 128 + n11 / 4;
        int n18 = 128 + n12 / 4;
        Color color4 = new Color(n16, n17, n18);
        Color color5 = new Color(n13, n14, n15);
        int n19 = (int)(0.35 * (double)n2);
        int n20 = (int)(0.04 * (double)n2);
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(0.0f, 0.0f, n, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{color4, color5, color5, color4, color4}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fillRect(0, n19, n, n20);
        graphics2D.setColor(color4);
        graphics2D.drawRect(0, n19, n - 1, n20);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.5f * (float)n - 3.0f, 4.0f);
        generalPath.quadTo(0.5f * (float)n, 0.0f, 0.5f * (float)n + 3.0f, 4.0f);
        generalPath.lineTo(n - 3, n3);
        generalPath.lineTo(2.0f, n3);
        generalPath.lineTo(0.5f * (float)n - 3.0f, 4.0f);
        graphics2D.setClip(generalPath);
        graphics2D.setPaint(new GradientPaint(0.0f, n3 / 2, color2, (int)(0.6 * (double)n), n3, color));
        graphics2D.fillRect(0, 0, n / 2, n3);
        graphics2D.setPaint(new GradientPaint(n, n3 / 2, color2, (int)(0.4 * (double)n), n3, color));
        graphics2D.fillRect(n / 2, 0, n / 2, n3);
        graphics2D.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics2D.setClip(null);
        graphics2D.setColor(new Color(64 + n10 / 2, 64 + n11 / 2, 64 + n12 / 2, 200));
        graphics2D.drawRect(0, n3, n - 1, n2 - n3 - 1);
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static int crayonX(int n) {
        return n % 8 * 22 + 4 + n / 8 % 2 * 11;
    }

    private static int crayonY(int n) {
        return n / 8 * 20 + 23;
    }

    public static Image getCrayonsImage() {
        int n = 195;
        int n2 = 208;
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(240, 240, 240));
        graphics2D.fillRect(0, 0, n, n2);
        for (int i = 0; i < crayonColors.length; ++i) {
            Color color = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage bufferedImage2 = SubstanceImageCreator.getSingleCrayon(color, 22, 120);
            graphics2D.drawImage((Image)bufferedImage2, SubstanceImageCreator.crayonX(i), SubstanceImageCreator.crayonY(i), null);
        }
        graphics2D.setColor(new Color(190, 190, 190));
        graphics2D.drawRoundRect(0, 1, n - 1, n2 - 2, 4, 4);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Icon getHexaMarker(int n, SubstanceColorScheme substanceColorScheme) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(9, 9);
        n %= 16;
        Color color = null;
        Color color2 = null;
        if (substanceColorScheme == null) {
            return new ImageIcon(bufferedImage);
        }
        boolean bl = substanceColorScheme.isDark();
        color = bl ? substanceColorScheme.getMidColor() : substanceColorScheme.getMidColor().darker();
        color2 = bl ? SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getUltraLightColor(), Color.white, 0.2) : substanceColorScheme.getUltraDarkColor().darker();
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 4) != 0;
        boolean bl5 = (n & 8) != 0;
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(bl2 ? color2 : color);
        graphics2D.fillOval(5, 5, 4, 4);
        graphics2D.setColor(bl3 ? color2 : color);
        graphics2D.fillOval(5, 0, 4, 4);
        graphics2D.setColor(bl4 ? color2 : color);
        graphics2D.fillOval(0, 5, 4, 4);
        graphics2D.setColor(bl5 ? color2 : color);
        graphics2D.fillOval(0, 0, 4, 4);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon getSearchIcon(int n, SubstanceColorScheme substanceColorScheme, boolean bl) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = SubstanceColorUtilities.getMarkColor(substanceColorScheme, true);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.5f));
        if (bl) {
            int n2 = (int)(0.6 * (double)n);
            int n3 = (int)(0.45 * (double)n);
            int n4 = (int)(0.3 * (double)n);
            graphics2D.drawOval(n2 - n4, n3 - n4, 2 * n4, 2 * n4);
            graphics2D.setStroke(new BasicStroke(3.0f));
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((double)n2 - (double)n4 / Math.sqrt(2.0)), (float)((double)n3 + (double)n4 / Math.sqrt(2.0)));
            generalPath.lineTo(1.8f, (float)n - 2.2f);
            graphics2D.draw(generalPath);
        } else {
            int n5 = (int)(0.4 * (double)n);
            int n6 = (int)(0.45 * (double)n);
            int n7 = (int)(0.3 * (double)n);
            graphics2D.drawOval(n5 - n7, n6 - n7, 2 * n7, 2 * n7);
            graphics2D.setStroke(new BasicStroke(3.0f));
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)((double)n5 + (double)n7 / Math.sqrt(2.0)), (float)((double)n6 + (double)n7 / Math.sqrt(2.0)));
            generalPath.lineTo((float)n - 2.5f, (float)n - 2.2f);
            graphics2D.draw(generalPath);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon getWatermarkIcon(SubstanceWatermark substanceWatermark) {
        int n = SubstanceSizeUtils.getTitlePaneIconSize();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        substanceWatermark.previewWatermark(graphics2D, SubstanceColorSchemeUtilities.METALLIC_SKIN, 0, 0, n, n);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon getSmallLockIcon(SubstanceColorScheme substanceColorScheme, Component component) {
        int n = SubstanceSizeUtils.getComponentFontSize(component);
        int n2 = SubstanceSizeUtils.getExtraPadding(n);
        int n3 = 6 + 2 * n2;
        int n4 = 9 + 2 * n2;
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
        Color color = substanceColorScheme.getForegroundColor();
        Color color2 = new Color(208, 208, 48);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics().create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(n) / 1.2f;
        float f2 = f / 2.0f;
        graphics2D.setStroke(new BasicStroke(f, 2, 1));
        float f3 = (float)n4 / 3.0f;
        float f4 = (float)n4 - f2;
        float f5 = f2;
        float f6 = (float)n3 - f2;
        graphics2D.setColor(color2);
        graphics2D.fill(new Rectangle2D.Float(f5, f3, f6 - f5, f4 - f3));
        graphics2D.setColor(color);
        graphics2D.draw(new Rectangle2D.Float(f5, f3, f6 - f5, f4 - f3));
        graphics2D.setColor(color);
        float f7 = (float)n3 / 4.0f;
        float f8 = (float)n3 - (float)n3 / 4.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f7, f3);
        generalPath.lineTo(f7, f2);
        generalPath.lineTo(f8, f2);
        generalPath.lineTo(f8, f3);
        graphics2D.draw(generalPath);
        graphics2D.setColor(color);
        float f9 = f3 + 2.0f * f;
        float f10 = f4 - 2.0f * f + 1.0f;
        float f11 = f7 + 1.0f;
        float f12 = f8;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.fill(new Rectangle2D.Float(f11, f9, f12 - f11, f10 - f9));
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static BufferedImage getNegated(BufferedImage bufferedImage) {
        return new NegatedFilter().filter(bufferedImage, null);
    }

    public static BufferedImage getColorSchemeImage(Component component, Icon icon, SubstanceColorScheme substanceColorScheme, float f) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return SubstanceImageCreator.getColorSchemeImage(bufferedImage, substanceColorScheme, f);
    }

    public static BufferedImage getColorSchemeImage(BufferedImage bufferedImage, SubstanceColorScheme substanceColorScheme, float f) {
        return ColorSchemeFilter.getColorSchemeFilter(substanceColorScheme, f).filter(bufferedImage, null);
    }

    public static class SimplisticSoftBorderReverseFillPainter
    extends SimplisticFillPainter {
        public static final SubstanceFillPainter INSTANCE = new SimplisticSoftBorderReverseFillPainter();

        private SimplisticSoftBorderReverseFillPainter() {
        }

        @Override
        public String getDisplayName() {
            return "Simplistic Soft Border Reverse";
        }

        @Override
        public Color getTopFillColor(SubstanceColorScheme substanceColorScheme) {
            return super.getBottomFillColor(substanceColorScheme);
        }

        @Override
        public Color getBottomFillColor(SubstanceColorScheme substanceColorScheme) {
            return super.getTopFillColor(substanceColorScheme);
        }
    }
}

