/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.visitors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.Visitor;
import jlibs.core.graph.sequences.IterableSequence;
import jlibs.core.graph.visitors.ClassSorter;

public abstract class ReflectionVisitor<E, R>
implements Visitor<E, R> {
    private Map<Class<?>, Method> methodMap = new HashMap();
    private Sequence<Class<?>> seq;

    private void sort() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            if (!method.getName().equals("process") || (params = method.getParameterTypes()).length != 1) continue;
            this.methodMap.put(params[0], method);
            method.setAccessible(true);
        }
        this.seq = new IterableSequence(ClassSorter.sort(this.methodMap.keySet()));
    }

    public void generateCode() {
        Class<?> clazz;
        if (this.seq == null) {
            this.sort();
        } else {
            this.seq.reset();
        }
        while ((clazz = this.seq.next()) != null) {
            System.out.print("        ");
            if (this.seq.index() != 0) {
                System.out.print("else ");
            }
            System.out.format("if(elem instanceof %s)%n", clazz.getSimpleName());
            System.out.format("            return process((%s)elem);%n", clazz.getSimpleName());
        }
        System.out.println("        else");
        System.out.println("           return getDefault(elem);");
    }

    @Override
    public R visit(E elem) {
        Class<?> clazz;
        if (this.seq == null) {
            this.sort();
        } else {
            this.seq.reset();
        }
        while ((clazz = this.seq.next()) != null) {
            if (!clazz.isAssignableFrom(elem.getClass())) continue;
            try {
                return (R)this.methodMap.get(clazz).invoke((Object)this, elem);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.getDefault(elem);
    }

    protected abstract R getDefault(Object var1);
}

