/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.plugimpl.StandardDialogSupportImpl;
import cz.vity.freerapid.plugins.container.ContainerException;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.plugins.container.FileInfo;
import cz.vity.freerapid.plugins.exceptions.ServiceConnectionProblemException;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class ImportLinksTask
extends CoreTask<List<FileInfo>, Void> {
    private static final Logger logger = Logger.getLogger(ImportLinksTask.class.getName());
    private final MainApp app;
    private final ContainerPlugin plugin;
    private final File[] files;
    private final File saveToDirectory = new File(AppPrefs.getProperty("lastComboPath", ""));

    public ImportLinksTask(MainApp mainApp, ContainerPlugin containerPlugin, File[] fileArray) {
        super((Application)mainApp);
        this.app = mainApp;
        this.plugin = containerPlugin;
        this.files = fileArray;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FileInfo> doInBackground() throws Exception {
        int n = 0;
        this.setProgress(n, 0, this.files.length);
        List<ConnectionSettings> list = this.app.getManagerDirector().getClientManager().getAvailableConnections();
        this.plugin.setConnectionSettings(list.isEmpty() ? null : list.get(0));
        this.plugin.setDialogSupport(new StandardDialogSupportImpl(this.app.getContext()));
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        for (File file : this.files) {
            this.message("importingLinks", new Object[]{Utils.shortenFileName(file)});
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                linkedList.addAll(this.plugin.read(inputStream, file.toString()));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        LogUtils.processException(logger, exception);
                    }
                }
            }
            this.setProgress(++n, 0, this.files.length);
        }
        if (linkedList.isEmpty()) {
            throw new ContainerException("noLinksFound");
        }
        return linkedList;
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        if (throwable instanceof ContainerException) {
            Swinger.showErrorMessage(this.getResourceMap(), throwable.getMessage(), new Object[0]);
        } else if (throwable instanceof ServiceConnectionProblemException) {
            if ("noAvailableConnection".equals(throwable.getMessage())) {
                Swinger.showErrorMessage(this.getResourceMap(), "noAvailableConnection", new Object[0]);
            } else {
                Swinger.showErrorMessage(this.getResourceMap(), "connectionProblem", Utils.getThrowableDescription(throwable));
            }
        } else if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "otherProblem", Utils.getThrowableDescription(throwable));
        }
    }

    protected void succeeded(List<FileInfo> list) {
        this.app.getManagerDirector().getDataManager().addLinksToQueueFromContainer(list, this.saveToDirectory, null, true);
    }
}

