/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;

public final class SpeedRegulator
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SpeedRegulator.class.getName());
    private Map<DownloadFile, DownloadFileInfo> downloading = new Hashtable<DownloadFile, DownloadFileInfo>(10);
    private final float SPEED_BACKUP = 1.3f;
    private static int globalSpeed;
    private final Object lock = new Object();
    private Timer timer = null;
    private static final int SPEED_MINIMUM_HOLDED = 10;
    private SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);
    private volatile long speed = 0L;
    private volatile float averageSpeed = 0.0f;

    public SpeedRegulator() {
        this.initProperties();
        this.initSpeeds();
    }

    private void initProperties() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("speedLimitEnabled".equals(preferenceChangeEvent.getKey()) || "speedLimit".equals(preferenceChangeEvent.getKey())) {
                    SpeedRegulator.this.initSpeeds();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSpeeds() {
        Object object = this.lock;
        synchronized (object) {
            globalSpeed = AppPrefs.getProperty("speedLimitEnabled", false) ? AppPrefs.getProperty("speedLimit", 250) : -1;
        }
    }

    private void assignTokensToFiles() {
        int n = this.downloading.size();
        Set<DownloadFile> set = this.downloading.keySet();
        if (globalSpeed > 0 && n > 0) {
            long l = globalSpeed;
            HashSet<DownloadFile> hashSet = new HashSet<DownloadFile>(set);
            boolean bl = true;
            do {
                int n2 = Math.max((int)((float)l / (float)hashSet.size()), 1);
                for (DownloadFile downloadFile : set) {
                    int n3;
                    int n4;
                    if (!hashSet.contains(downloadFile)) continue;
                    if (bl) {
                        downloadFile.setTokensLimit(0);
                    }
                    int n5 = downloadFile.getTakenTokens();
                    if (downloadFile.hasSpeedLimit()) {
                        n4 = Math.min(downloadFile.getSpeedLimit() - downloadFile.getTokensLimit(), n2);
                        n3 = n5 < 0 || n == 1 ? n4 : (n5 > 0 ? Math.min(n4, (int)((float)n5 * 1.3f)) : Math.min(n4, 10));
                        assert (n3 >= 0);
                        if (downloadFile.getTokensLimit() + n3 == downloadFile.getSpeedLimit()) {
                            hashSet.remove(downloadFile);
                        }
                    } else {
                        if (n5 < 0 || n == 1) {
                            n3 = n2;
                        } else if (n5 > 0) {
                            if (bl) {
                                n3 = Math.min(n2, (int)((float)n5 * 1.3f));
                            } else {
                                n4 = (int)((float)n5 * 1.3f);
                                n3 = Math.min(n2, Math.min(n4, Math.abs(n4 - downloadFile.getTokensLimit())));
                                if (n3 == 0) {
                                    n3 = 1;
                                }
                            }
                        } else {
                            n3 = Math.min(n2, 10);
                        }
                        assert (n3 >= 0);
                    }
                    l -= (long)n3;
                    downloadFile.setTokensLimit(downloadFile.getTokensLimit() + n3);
                }
                bl = false;
            } while (l > 0L && hashSet.size() > 0);
            for (DownloadFile downloadFile : set) {
                downloadFile.setTakenTokens(0);
            }
        } else {
            for (DownloadFile downloadFile : set) {
                downloadFile.setTokensLimit(downloadFile.hasSpeedLimit() ? downloadFile.getSpeedLimit() : Integer.MAX_VALUE);
                downloadFile.setTakenTokens(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        Object object = this.lock;
        synchronized (object) {
            this.assignTokensToFiles();
            long l = 0L;
            float f = 0.0f;
            int n = this.downloading.size();
            for (DownloadFileInfo downloadFileInfo : this.downloading.values()) {
                if (downloadFileInfo.file.getState() != DownloadState.DOWNLOADING) continue;
                downloadFileInfo.tick();
                l += downloadFileInfo.speed;
                f += downloadFileInfo.averageSpeed;
            }
            this.fireSpeed(l);
            this.fireAvgSpeed(f / (float)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean takeTokens(DownloadFile downloadFile, int n) {
        int n2 = (int)Math.round((double)n / 1024.0);
        Object object = this.lock;
        synchronized (object) {
            DownloadFileInfo downloadFileInfo = this.downloading.get(downloadFile);
            if (downloadFileInfo == null) {
                return true;
            }
            downloadFileInfo.counter += n;
            int n3 = downloadFile.getTakenTokens();
            downloadFile.setTakenTokens(n3 == -1 ? n2 : n3 + n2);
            return downloadFile.getTokensLimit() > downloadFile.getTakenTokens();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDownloading(DownloadFile downloadFile, DownloadTask downloadTask) {
        Object object = this.lock;
        synchronized (object) {
            downloadFile.setTakenTokens(-1);
            downloadFile.addPropertyChangeListener("state", this);
            downloadFile.setTokensLimit(Integer.MAX_VALUE);
            downloadFile.setSpeed(0L);
            downloadFile.setAverageSpeed(0.0f);
            this.downloading.put(downloadFile, new DownloadFileInfo(downloadTask));
            if (this.timer == null) {
                this.timer = new Timer("SpeedRegulatorTimer");
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SpeedRegulator.this.tick();
                    }
                }, 0L, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDownloading(DownloadFile downloadFile) {
        Object object = this.lock;
        synchronized (object) {
            this.downloading.remove(downloadFile);
            downloadFile.removePropertyChangeListener("state", this);
            downloadFile.setSpeed(0L);
            if (this.timer != null && this.downloading.isEmpty()) {
                this.fireSpeed(0L);
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    private void fireSpeed(long l) {
        long l2 = this.speed;
        this.speed = l;
        this.pcs.firePropertyChange("speed", l2, this.speed);
    }

    private void fireAvgSpeed(float f) {
        float f2 = this.averageSpeed;
        this.averageSpeed = f;
        this.pcs.firePropertyChange("averageSpeed", Float.valueOf(f2), Float.valueOf(this.averageSpeed));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DownloadFile downloadFile = (DownloadFile)propertyChangeEvent.getSource();
        if (downloadFile.getState() != DownloadState.DOWNLOADING) {
            this.removeDownloading(downloadFile);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public long getSpeed() {
        return this.speed;
    }

    private static class DownloadFileInfo {
        private volatile long counter = 0L;
        private long lastSize = 0L;
        private int noDataTimeOut = 0;
        private short indexer = 0;
        private long[] avgSpeedArray;
        private final DownloadTask task;
        private final long startTime;
        private int avgSpeedMeasuredSeconds;
        private static final int NO_DATA_TIMEOUT_LIMIT = 120;
        private float avgSpeed;
        private static final int[] bufferSizes = new int[]{1024, 2048, 5120, 10240, 25600, 51200};
        private byte[][] buffers = new byte[bufferSizes.length][];
        private DownloadFile file;
        private long speed;
        private float averageSpeed;
        private long downloadedStart;

        DownloadFileInfo(DownloadTask downloadTask) {
            this.task = downloadTask;
            this.file = downloadTask.getDownloadFile();
            this.downloadedStart = this.file.getDownloaded();
            this.avgSpeedMeasuredSeconds = AppPrefs.getProperty("avgSpeedMeasuredSeconds", 10);
            this.avgSpeedArray = new long[this.avgSpeedMeasuredSeconds];
            Arrays.fill(this.avgSpeedArray, -1L);
            this.startTime = System.currentTimeMillis();
            this.avgSpeed = 0.0f;
            this.speed = 0L;
            this.averageSpeed = 0.0f;
        }

        private void updateShortAvgSpeed() {
            int n = 0;
            long l = 0L;
            for (long l2 : this.avgSpeedArray) {
                if (l2 == -1L) continue;
                l += l2;
                ++n;
            }
            this.avgSpeed = n == 0 ? 0.0f : (float)l / (float)n;
            this.file.setShortTimeAvgSpeed(this.avgSpeed);
        }

        void tick() {
            long l;
            float f;
            long l2 = this.counter;
            this.speed = l2 - this.lastSize;
            this.file.setSpeed(this.speed);
            if (this.speed == 0L) {
                if (++this.noDataTimeOut >= 120) {
                    logger.info("Cancelling download - no downloaded data during 120 seconds");
                    this.averageSpeed = 0.0f;
                    this.task.setConnectionTimeOut(true);
                    this.task.cancel(true);
                    return;
                }
            } else {
                this.noDataTimeOut = 0;
                this.lastSize = l2;
                this.file.setDownloaded(this.downloadedStart + l2);
            }
            this.averageSpeed = Float.compare(f = (float)(l = System.currentTimeMillis() - this.startTime) / 1000.0f, 0.0f) == 0 ? 0.0f : (float)l2 / f;
            this.file.setAverageSpeed(this.averageSpeed);
            if (this.indexer == this.avgSpeedMeasuredSeconds) {
                this.indexer = 0;
            }
            short s = this.indexer;
            this.indexer = (short)(s + 1);
            this.avgSpeedArray[s] = this.speed;
            this.updateShortAvgSpeed();
            this.updateBufferSize(this.speed);
        }

        private void updateBufferSize(long l) {
            int n = Math.min((int)((float)l / 1024.0f), this.file.getTokensLimit() - Math.max(this.file.getTakenTokens(), 0));
            if (n < 0) {
                n = 10;
            }
            if (this.file.hasSpeedLimit() || globalSpeed > 0) {
                n /= 4;
            }
            int n2 = n > 50 ? (n >= 300 ? 5 : 4) : (n > 15 ? (n >= 31 ? 3 : 2) : (n >= 6 ? 1 : 0));
            byte[] byArray = this.buffers[n2];
            if (byArray != null) {
                this.task.setBuffer(byArray);
            } else {
                byArray = new byte[bufferSizes[n2]];
                this.task.setBuffer(byArray);
                this.buffers[n2] = byArray;
            }
        }
    }
}

