/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.dialogs.UserPreferencesDialog;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Frame;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;

public class OptionsActions
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(OptionsActions.class.getName());
    private final MainApp app = (MainApp)MainApp.getInstance(MainApp.class);
    private static final String REFRESH_PROXY_LIST_ACTION_ENABLED_PROPERTY = "refreshProxyListActionEnabled";
    private boolean refreshProxyListActionEnabled = false;

    public OptionsActions() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent preferenceChangeEvent) {
                if ("useProxyList".equals(preferenceChangeEvent.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionsActions.this.setRefreshProxyListActionEnabled(Boolean.parseBoolean(preferenceChangeEvent.getNewValue()));
                        }
                    });
                }
            }
        });
    }

    @Action
    public void options() {
        try {
            UserPreferencesDialog userPreferencesDialog = new UserPreferencesDialog((Frame)this.app.getMainFrame(), this.app.getContext());
            this.app.prepareDialog(userPreferencesDialog, true);
            this.app.getAppPrefs().store();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Action
    public void monitorClipboardAction() {
        AppPrefs.negateProperty("clipboardMonitoring", true);
    }

    @Action
    public void globalSpeedLimitAction() {
        AppPrefs.negateProperty("speedLimitEnabled", false);
    }

    @Action
    public void shutdownDisabledAction() {
        this.setShutdownProperty(0);
    }

    private void setShutdownProperty(int n) {
        AppPrefs.storeProperty("autoshutdown", n);
    }

    @Action
    public void shutdownQuitAction() {
        this.setShutdownProperty(1);
    }

    @Action
    public void shutdownHibernateAction() {
        this.updateShutdown(OSCommand.HIBERNATE, 5);
    }

    @Action
    public void shutdownShutdownAction() {
        this.updateShutdown(OSCommand.SHUTDOWN, 4);
    }

    @Action
    public void shutdownStandByAction() {
        this.updateShutdown(OSCommand.STANDBY, 2);
    }

    @Action
    public void shutdownRebootAction() {
        this.updateShutdown(OSCommand.REBOOT, 3);
    }

    private void updateShutdown(OSCommand oSCommand, int n) {
        SystemCommander systemCommander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.app.getContext());
        if (!systemCommander.isSupported(oSCommand)) {
            this.setShutdownProperty(0);
            Swinger.showErrorMessage(this.app.getContext().getResourceMap(), "systemCommandNotSupported", oSCommand.toString().toLowerCase());
        } else {
            this.setShutdownProperty(n);
        }
    }

    @Action
    public void globalLimitSpeedAction() {
        AppPrefs.negateProperty("speedLimitEnabled", false);
    }

    @Action(enabledProperty="refreshProxyListActionEnabled")
    public void refreshProxyList() {
        this.app.getManagerDirector().getClientManager().updateConnectionSettings();
    }

    public void setRefreshProxyListActionEnabled(boolean bl) {
        boolean bl2 = this.refreshProxyListActionEnabled;
        this.refreshProxyListActionEnabled = bl;
        this.firePropertyChange(REFRESH_PROXY_LIST_ACTION_ENABLED_PROPERTY, bl2, this.refreshProxyListActionEnabled);
    }

    public boolean isRefreshProxyListActionEnabled() {
        return this.refreshProxyListActionEnabled;
    }
}

