/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;

final class ServiceCellRenderer
extends DefaultTableCellRenderer {
    private final PluginsManager manager;
    private final Map<String, Icon> iconCache = new HashMap<String, Icon>();

    ServiceCellRenderer(ManagerDirector managerDirector) {
        this.manager = managerDirector.getPluginsManager();
        Icon icon = managerDirector.getContext().getResourceMap().getIcon("serviceWithNoIcon");
        this.iconCache.put("default", icon);
        this.manager.getPluginManager().registerListener((PluginManager.EventListener)new PluginManager.EventListenerAdapter(){

            public void pluginActivated(Plugin plugin) {
                ServiceCellRenderer.this.iconCache.remove(plugin.getDescriptor().getId());
            }

            public void pluginEnabled(PluginDescriptor pluginDescriptor) {
                ServiceCellRenderer.this.iconCache.remove(pluginDescriptor.getId());
            }
        });
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        DownloadFile downloadFile = (DownloadFile)object;
        String string = downloadFile.getPluginID();
        assert (string != null);
        String string2 = downloadFile.getServiceName();
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        Icon icon = this.iconCache.get(string);
        if (icon == null) {
            try {
                ShareDownloadService shareDownloadService;
                if (this.manager.hasPlugin(string) && !this.manager.isPluginDisabled(string) && this.manager.getPluginMetadata(string).hasFavicon() && (icon = (shareDownloadService = this.manager.getPluginInstance(string)).getFaviconImage()) != null) {
                    this.iconCache.put(string, icon);
                }
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                // empty catch block
            }
            if (icon == null) {
                icon = this.iconCache.get("default");
                this.iconCache.put(string, icon);
            }
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        if (!AppPrefs.getProperty("showServicesAsIcons", true)) {
            this.setHorizontalAlignment(2);
            this.setText(string2);
            this.setToolTipText(null);
        } else {
            this.setToolTipText(string2);
            this.setText(null);
            this.setHorizontalAlignment(0);
        }
        this.getAccessibleContext().setAccessibleName(jTable.getColumnName(n2) + " " + string2);
        return this;
    }
}

