/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.interfaces.FileStreamRecognizer;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

public class DefaultFileStreamRecognizer
implements FileStreamRecognizer {
    private static final Logger logger = Logger.getLogger(DefaultFileStreamRecognizer.class.getName());
    private final String[] allowedValues;
    private final String[] forbiddenValues;
    private final boolean exactMatch;

    public DefaultFileStreamRecognizer() {
        this.allowedValues = new String[0];
        this.forbiddenValues = new String[0];
        this.exactMatch = false;
    }

    public DefaultFileStreamRecognizer(String[] stringArray, boolean bl) {
        this(stringArray, new String[0], bl);
    }

    public DefaultFileStreamRecognizer(String[] stringArray, String[] stringArray2, boolean bl) {
        this.allowedValues = stringArray;
        this.exactMatch = bl;
        this.forbiddenValues = stringArray2;
    }

    @Override
    public boolean isStream(HttpMethod httpMethod, boolean bl) {
        int n;
        Header header = this.getContentType(httpMethod);
        String string = null;
        if (header != null) {
            string = header.getValue().toLowerCase(Locale.ENGLISH);
        } else if (bl) {
            logger.warning("No Content-Type!");
        }
        boolean bl2 = false;
        for (String string2 : this.allowedValues) {
            if (string2 == null) {
                if (string != null) continue;
                bl2 = true;
                break;
            }
            if (string == null || !string.startsWith(string2 = string2.toLowerCase(Locale.ENGLISH))) continue;
            bl2 = true;
            break;
        }
        for (String string2 : this.forbiddenValues) {
            if (!(string2 == null ? string == null : string != null && string.startsWith(string2 = string2.toLowerCase(Locale.ENGLISH)))) continue;
            return false;
        }
        if (bl2) {
            return true;
        }
        if (this.exactMatch) {
            if (bl && this.allowedValues.length > 0) {
                logger.warning("Content type " + string + " is not on supported list " + Arrays.toString(this.allowedValues));
            }
            return false;
        }
        if (header == null || string == null) {
            return false;
        }
        if (DefaultFileStreamRecognizer.isApplicationXML(string)) {
            return false;
        }
        boolean bl3 = string.startsWith("image/");
        int n2 = 1;
        int n3 = n = string.startsWith("audio/") || string.startsWith("video/") ? 1 : 0;
        if (!(string.startsWith("application/") || bl3 || n)) {
            n2 = 0;
            if (bl) {
                logger.warning("Suspicious Content-Type: " + header.getValue());
            }
        }
        return n2 != 0;
    }

    protected Header getContentType(HttpMethod httpMethod) {
        return httpMethod.getResponseHeader("Content-Type");
    }

    private static boolean isApplicationXML(String string) {
        return string.startsWith("application/") && string.lastIndexOf("xml") > 0;
    }
}

