/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.hoster;

import cz.vity.freerapid.plugins.exceptions.FailedToLoadCaptchaPictureException;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.HttpMethod;

public class CaptchaSupport {
    private final HttpDownloadClient client;
    private final DialogSupport dialogSupport;

    public CaptchaSupport(HttpDownloadClient httpDownloadClient, DialogSupport dialogSupport) {
        this.client = httpDownloadClient;
        this.dialogSupport = dialogSupport;
    }

    public String askForCaptcha(BufferedImage bufferedImage) throws Exception {
        return this.dialogSupport.askForCaptcha(bufferedImage);
    }

    public String getCaptcha(String string) throws FailedToLoadCaptchaPictureException {
        try {
            return this.dialogSupport.askForCaptcha(this.getImageIcon(string));
        }
        catch (FailedToLoadCaptchaPictureException failedToLoadCaptchaPictureException) {
            throw failedToLoadCaptchaPictureException;
        }
        catch (Exception exception) {
            throw new FailedToLoadCaptchaPictureException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getImageIcon(String string) throws FailedToLoadCaptchaPictureException {
        ImageIcon imageIcon;
        ByteArrayOutputStream byteArrayOutputStream;
        block19: {
            InputStream inputStream = null;
            byteArrayOutputStream = null;
            try {
                int n;
                inputStream = this.loadStream(string);
                if (inputStream == null) {
                    throw new NullPointerException("InputStreamForCaptchaIsNull");
                }
                byte[] byArray = new byte[4096];
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
                if (inputStream == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (FailedToLoadCaptchaPictureException failedToLoadCaptchaPictureException) {
                    throw failedToLoadCaptchaPictureException;
                }
                catch (Exception exception) {
                    throw new FailedToLoadCaptchaPictureException(exception);
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageIcon;
    }

    public BufferedImage getCaptchaImage(String string) throws FailedToLoadCaptchaPictureException {
        try {
            return this.loadCaptcha(this.loadStream(string));
        }
        catch (FailedToLoadCaptchaPictureException failedToLoadCaptchaPictureException) {
            throw failedToLoadCaptchaPictureException;
        }
        catch (Exception exception) {
            throw new FailedToLoadCaptchaPictureException(exception);
        }
    }

    private InputStream loadStream(String string) throws IOException, FailedToLoadCaptchaPictureException {
        InputStream inputStream = this.client.makeRequestForFile((HttpMethod)this.client.getGetMethod(string));
        if (inputStream == null) {
            throw new FailedToLoadCaptchaPictureException();
        }
        return inputStream;
    }

    public BufferedImage loadCaptcha(InputStream inputStream) throws FailedToLoadCaptchaPictureException {
        if (inputStream == null) {
            throw new NullPointerException("InputStreamForCaptchaIsNull");
        }
        try {
            return ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            throw new FailedToLoadCaptchaPictureException("ReadingCaptchaPictureFailed", iOException);
        }
    }
}

