/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class ScriptUtils {
    private ScriptUtils() {
    }

    public static Object evaluateJavaScript(String string) throws PluginImplementationException {
        ScriptEngine scriptEngine = ScriptUtils.getJavaScriptEngine();
        try {
            return scriptEngine.eval(string);
        }
        catch (Exception exception) {
            throw new PluginImplementationException("Script execution failed", exception);
        }
    }

    public static String evaluateJavaScriptToString(String string) throws PluginImplementationException {
        Object object = ScriptUtils.evaluateJavaScript(string);
        if (object instanceof String) {
            return (String)object;
        }
        throw new PluginImplementationException("Wrong script return type: " + object.getClass().getName() + ", expected String");
    }

    public static Number evaluateJavaScriptToNumber(String string) throws PluginImplementationException {
        Object object = ScriptUtils.evaluateJavaScript(string);
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new PluginImplementationException("Wrong script return type: " + object.getClass().getName() + ", expected Number");
    }

    private static ScriptEngine getJavaScriptEngine() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
        if (scriptEngine == null) {
            throw new RuntimeException("JavaScript engine not found");
        }
        return scriptEngine;
    }
}

