/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.models;

import cz.vity.freerapid.core.AppPrefs;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;

public final class SimplePreferencesComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String keyProperties = null;
    private boolean autosave;
    private int maxRecentPhrasesCount;

    public SimplePreferencesComboModel(String string, boolean bl) {
        this(AppPrefs.getProperty("maxRecentPhrasesCount", 6), string, bl);
    }

    public SimplePreferencesComboModel(int n, String string, boolean bl) {
        this(new Stack<String>());
        String[] stringArray;
        this.maxRecentPhrasesCount = n;
        this.keyProperties = string;
        this.autosave = bl;
        for (String string2 : stringArray = AppPrefs.getProperty(string, "").split("\\|")) {
            if (string2.length() <= 0) continue;
            this.stack.add(0, string2);
        }
    }

    private SimplePreferencesComboModel(Stack<String> stack) {
        super(stack);
        this.stack = stack;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        this.addElement(object);
    }

    @Override
    public final void addElement(Object object) {
        if (object == null) {
            return;
        }
        int n = this.getIndexOf(object);
        if (n < 0) {
            String string = object.toString().trim();
            if (!"".equals(string) && !"?".equals(string)) {
                super.insertElementAt(object, 0);
                if (this.stack.size() > this.maxRecentPhrasesCount) {
                    this.remove(this.maxRecentPhrasesCount - 1);
                    if (this.autosave) {
                        this.store();
                    }
                }
            }
            if (this.autosave) {
                this.store();
            }
        }
    }

    private void remove(int n) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        AppPrefs.removeProperty(this.keyProperties);
    }

    public void store() {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>(this.stack);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        AppPrefs.storeProperty(this.keyProperties, stringBuilder.toString());
    }
}

