/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.WindowState;
import org.jdesktop.application.utils.SwingHelper;

public class WindowProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof Window)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    private int getScreenCount() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length;
    }

    @Override
    public Object getSessionState(Component component) {
        GraphicsConfiguration graphicsConfiguration;
        this.checkComponent(component);
        int n = 0;
        if (component instanceof Frame) {
            n = ((Frame)component).getExtendedState();
        }
        Rectangle rectangle = (graphicsConfiguration = component.getGraphicsConfiguration()) == null ? null : graphicsConfiguration.getBounds();
        Rectangle rectangle2 = component.getBounds();
        if (component instanceof JFrame && 0 != (n & 6)) {
            String string = "WindowState.normalBounds";
            Object object = ((JFrame)component).getRootPane().getClientProperty(string);
            if (object instanceof Rectangle) {
                rectangle2 = (Rectangle)object;
            }
        }
        if (rectangle2.isEmpty()) {
            return null;
        }
        return new WindowState(rectangle2, rectangle, this.getScreenCount(), n);
    }

    @Override
    public void setSessionState(Component component, Object object) {
        this.checkComponent(component);
        if (object != null && !(object instanceof WindowState)) {
            throw new IllegalArgumentException("invalid state");
        }
        Window window = (Window)component;
        if (!window.isLocationByPlatform() && object != null) {
            WindowState windowState = (WindowState)object;
            Rectangle rectangle = windowState.getGraphicsConfigurationBounds();
            if (rectangle != null && SwingHelper.isResizable(window)) {
                if (SwingHelper.computeVirtualGraphicsBounds().contains(rectangle.getLocation())) {
                    window.setBounds(windowState.getBounds());
                } else {
                    window.setSize(windowState.getBounds().getSize());
                }
            }
            if (window instanceof Frame) {
                ((Frame)window).setExtendedState(windowState.getFrameState());
            }
        }
    }
}

